/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudhsm.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudhsm.model.DescribeLunaClientRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;

public class DescribeLunaClientRequestMarshaller
implements Marshaller<Request<DescribeLunaClientRequest>, DescribeLunaClientRequest> {
    @Override
    public Request<DescribeLunaClientRequest> marshall(DescribeLunaClientRequest describeLunaClientRequest) {
        if (describeLunaClientRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeLunaClientRequest> request = new DefaultRequest<DescribeLunaClientRequest>(describeLunaClientRequest, "AWSCloudHSM");
        request.addHeader("X-Amz-Target", "CloudHsmFrontendService.DescribeLunaClient");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.1");
            jsonGenerator.writeStartObject();
            if (describeLunaClientRequest.getClientArn() != null) {
                jsonGenerator.writeFieldName("ClientArn").writeValue(describeLunaClientRequest.getClientArn());
            }
            if (describeLunaClientRequest.getCertificateFingerprint() != null) {
                jsonGenerator.writeFieldName("CertificateFingerprint").writeValue(describeLunaClientRequest.getCertificateFingerprint());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

