/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.route53.model.ListHostedZonesByNameRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ListHostedZonesByNameRequestMarshaller
implements Marshaller<Request<ListHostedZonesByNameRequest>, ListHostedZonesByNameRequest> {
    @Override
    public Request<ListHostedZonesByNameRequest> marshall(ListHostedZonesByNameRequest listHostedZonesByNameRequest) {
        if (listHostedZonesByNameRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListHostedZonesByNameRequest> request = new DefaultRequest<ListHostedZonesByNameRequest>(listHostedZonesByNameRequest, "AmazonRoute53");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2013-04-01/hostedzonesbyname";
        request.setResourcePath(uriResourcePath);
        if (listHostedZonesByNameRequest.getDNSName() != null) {
            request.addParameter("dnsname", StringUtils.fromString(listHostedZonesByNameRequest.getDNSName()));
        }
        if (listHostedZonesByNameRequest.getHostedZoneId() != null) {
            request.addParameter("hostedzoneid", StringUtils.fromString(listHostedZonesByNameRequest.getHostedZoneId()));
        }
        if (listHostedZonesByNameRequest.getMaxItems() != null) {
            request.addParameter("maxitems", StringUtils.fromString(listHostedZonesByNameRequest.getMaxItems()));
        }
        return request;
    }
}

