/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisfirehose.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.kinesisfirehose.model.ElasticsearchDestinationConfiguration;
import com.amazonaws.services.kinesisfirehose.model.transform.CloudWatchLoggingOptionsJsonMarshaller;
import com.amazonaws.services.kinesisfirehose.model.transform.ElasticsearchBufferingHintsJsonMarshaller;
import com.amazonaws.services.kinesisfirehose.model.transform.ElasticsearchRetryOptionsJsonMarshaller;
import com.amazonaws.services.kinesisfirehose.model.transform.S3DestinationConfigurationJsonMarshaller;
import com.amazonaws.util.json.StructuredJsonGenerator;

public class ElasticsearchDestinationConfigurationJsonMarshaller {
    private static ElasticsearchDestinationConfigurationJsonMarshaller instance;

    public void marshall(ElasticsearchDestinationConfiguration elasticsearchDestinationConfiguration, StructuredJsonGenerator jsonGenerator) {
        if (elasticsearchDestinationConfiguration == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (elasticsearchDestinationConfiguration.getRoleARN() != null) {
                jsonGenerator.writeFieldName("RoleARN").writeValue(elasticsearchDestinationConfiguration.getRoleARN());
            }
            if (elasticsearchDestinationConfiguration.getDomainARN() != null) {
                jsonGenerator.writeFieldName("DomainARN").writeValue(elasticsearchDestinationConfiguration.getDomainARN());
            }
            if (elasticsearchDestinationConfiguration.getIndexName() != null) {
                jsonGenerator.writeFieldName("IndexName").writeValue(elasticsearchDestinationConfiguration.getIndexName());
            }
            if (elasticsearchDestinationConfiguration.getTypeName() != null) {
                jsonGenerator.writeFieldName("TypeName").writeValue(elasticsearchDestinationConfiguration.getTypeName());
            }
            if (elasticsearchDestinationConfiguration.getIndexRotationPeriod() != null) {
                jsonGenerator.writeFieldName("IndexRotationPeriod").writeValue(elasticsearchDestinationConfiguration.getIndexRotationPeriod());
            }
            if (elasticsearchDestinationConfiguration.getBufferingHints() != null) {
                jsonGenerator.writeFieldName("BufferingHints");
                ElasticsearchBufferingHintsJsonMarshaller.getInstance().marshall(elasticsearchDestinationConfiguration.getBufferingHints(), jsonGenerator);
            }
            if (elasticsearchDestinationConfiguration.getRetryOptions() != null) {
                jsonGenerator.writeFieldName("RetryOptions");
                ElasticsearchRetryOptionsJsonMarshaller.getInstance().marshall(elasticsearchDestinationConfiguration.getRetryOptions(), jsonGenerator);
            }
            if (elasticsearchDestinationConfiguration.getS3BackupMode() != null) {
                jsonGenerator.writeFieldName("S3BackupMode").writeValue(elasticsearchDestinationConfiguration.getS3BackupMode());
            }
            if (elasticsearchDestinationConfiguration.getS3Configuration() != null) {
                jsonGenerator.writeFieldName("S3Configuration");
                S3DestinationConfigurationJsonMarshaller.getInstance().marshall(elasticsearchDestinationConfiguration.getS3Configuration(), jsonGenerator);
            }
            if (elasticsearchDestinationConfiguration.getCloudWatchLoggingOptions() != null) {
                jsonGenerator.writeFieldName("CloudWatchLoggingOptions");
                CloudWatchLoggingOptionsJsonMarshaller.getInstance().marshall(elasticsearchDestinationConfiguration.getCloudWatchLoggingOptions(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ElasticsearchDestinationConfigurationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ElasticsearchDestinationConfigurationJsonMarshaller();
        }
        return instance;
    }
}

