/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.codepipeline.model.PutJobSuccessResultRequest;
import com.amazonaws.services.codepipeline.model.transform.CurrentRevisionJsonMarshaller;
import com.amazonaws.services.codepipeline.model.transform.ExecutionDetailsJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;

public class PutJobSuccessResultRequestMarshaller
implements Marshaller<Request<PutJobSuccessResultRequest>, PutJobSuccessResultRequest> {
    @Override
    public Request<PutJobSuccessResultRequest> marshall(PutJobSuccessResultRequest putJobSuccessResultRequest) {
        if (putJobSuccessResultRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PutJobSuccessResultRequest> request = new DefaultRequest<PutJobSuccessResultRequest>(putJobSuccessResultRequest, "AWSCodePipeline");
        request.addHeader("X-Amz-Target", "CodePipeline_20150709.PutJobSuccessResult");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.1");
            jsonGenerator.writeStartObject();
            if (putJobSuccessResultRequest.getJobId() != null) {
                jsonGenerator.writeFieldName("jobId").writeValue(putJobSuccessResultRequest.getJobId());
            }
            if (putJobSuccessResultRequest.getCurrentRevision() != null) {
                jsonGenerator.writeFieldName("currentRevision");
                CurrentRevisionJsonMarshaller.getInstance().marshall(putJobSuccessResultRequest.getCurrentRevision(), jsonGenerator);
            }
            if (putJobSuccessResultRequest.getContinuationToken() != null) {
                jsonGenerator.writeFieldName("continuationToken").writeValue(putJobSuccessResultRequest.getContinuationToken());
            }
            if (putJobSuccessResultRequest.getExecutionDetails() != null) {
                jsonGenerator.writeFieldName("executionDetails");
                ExecutionDetailsJsonMarshaller.getInstance().marshall(putJobSuccessResultRequest.getExecutionDetails(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

