/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.codepipeline.model.ArtifactStore;
import com.amazonaws.services.codepipeline.model.transform.EncryptionKeyJsonMarshaller;
import com.amazonaws.util.json.StructuredJsonGenerator;

public class ArtifactStoreJsonMarshaller {
    private static ArtifactStoreJsonMarshaller instance;

    public void marshall(ArtifactStore artifactStore, StructuredJsonGenerator jsonGenerator) {
        if (artifactStore == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (artifactStore.getType() != null) {
                jsonGenerator.writeFieldName("type").writeValue(artifactStore.getType());
            }
            if (artifactStore.getLocation() != null) {
                jsonGenerator.writeFieldName("location").writeValue(artifactStore.getLocation());
            }
            if (artifactStore.getEncryptionKey() != null) {
                jsonGenerator.writeFieldName("encryptionKey");
                EncryptionKeyJsonMarshaller.getInstance().marshall(artifactStore.getEncryptionKey(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ArtifactStoreJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ArtifactStoreJsonMarshaller();
        }
        return instance;
    }
}

