/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.PutMethodRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;
import java.util.Map;

public class PutMethodRequestMarshaller
implements Marshaller<Request<PutMethodRequest>, PutMethodRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<PutMethodRequest> marshall(PutMethodRequest putMethodRequest) {
        if (putMethodRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PutMethodRequest> request = new DefaultRequest<PutMethodRequest>(putMethodRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.PUT);
        String uriResourcePath = "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", putMethodRequest.getRestApiId() != null ? StringUtils.fromString(putMethodRequest.getRestApiId()) : DEFAULT_CONTENT_TYPE);
        uriResourcePath = uriResourcePath.replace("{resource_id}", putMethodRequest.getResourceId() != null ? StringUtils.fromString(putMethodRequest.getResourceId()) : DEFAULT_CONTENT_TYPE);
        uriResourcePath = uriResourcePath.replace("{http_method}", putMethodRequest.getHttpMethod() != null ? StringUtils.fromString(putMethodRequest.getHttpMethod()) : DEFAULT_CONTENT_TYPE);
        request.setResourcePath(uriResourcePath);
        try {
            Map<String, String> requestModelsMap;
            Map<String, Boolean> requestParametersMap;
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            if (putMethodRequest.getAuthorizationType() != null) {
                jsonGenerator.writeFieldName("authorizationType").writeValue(putMethodRequest.getAuthorizationType());
            }
            if (putMethodRequest.getAuthorizerId() != null) {
                jsonGenerator.writeFieldName("authorizerId").writeValue(putMethodRequest.getAuthorizerId());
            }
            if (putMethodRequest.getApiKeyRequired() != null) {
                jsonGenerator.writeFieldName("apiKeyRequired").writeValue(putMethodRequest.getApiKeyRequired());
            }
            if ((requestParametersMap = putMethodRequest.getRequestParameters()) != null) {
                jsonGenerator.writeFieldName("requestParameters");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, Boolean> requestParametersMapValue : requestParametersMap.entrySet()) {
                    if (requestParametersMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(requestParametersMapValue.getKey());
                    jsonGenerator.writeValue(requestParametersMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            if ((requestModelsMap = putMethodRequest.getRequestModels()) != null) {
                jsonGenerator.writeFieldName("requestModels");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, String> requestModelsMapValue : requestModelsMap.entrySet()) {
                    if (requestModelsMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(requestModelsMapValue.getKey());
                    jsonGenerator.writeValue(requestModelsMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

