/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codegen;

import com.amazonaws.codegen.AddShapes;
import com.amazonaws.codegen.internal.NameUtils;
import com.amazonaws.codegen.internal.Utils;
import com.amazonaws.codegen.model.config.customization.CustomizationConfig;
import com.amazonaws.codegen.model.intermediate.ShapeModel;
import com.amazonaws.codegen.model.intermediate.ShapeType;
import com.amazonaws.codegen.model.intermediate.ShapeUnmarshaller;
import com.amazonaws.codegen.model.service.ServiceModel;
import com.amazonaws.codegen.model.service.Shape;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

final class AddModelShapes
extends AddShapes {
    AddModelShapes(ServiceModel serviceModel, CustomizationConfig customizationConfig) {
        super(serviceModel, customizationConfig);
    }

    public final Map<String, ShapeModel> constructModelShapes(Set<String> shapesToSkip) {
        HashMap<String, ShapeModel> javaShapes = new HashMap<String, ShapeModel>();
        for (Map.Entry<String, Shape> entry : this.getServiceModel().getShapes().entrySet()) {
            ShapeType shapeType;
            String shapeName = entry.getKey();
            Shape shape = entry.getValue();
            if (shapesToSkip.contains(shapeName) || (shapeType = this.getModelShapeType(shape)) == null) continue;
            String javaClassName = NameUtils.getJavaClassName(shapeName);
            ShapeModel modelShape = this.generateShapeModel(javaClassName, shapeName);
            modelShape.setType(shapeType);
            ShapeUnmarshaller unmarshaller = new ShapeUnmarshaller();
            unmarshaller.setFlattened(shape.isFlattened());
            modelShape.setUnmarshaller(unmarshaller);
            javaShapes.put(javaClassName, modelShape);
        }
        return javaShapes;
    }

    private ShapeType getModelShapeType(Shape shape) {
        if (Utils.isStructure(shape)) {
            return ShapeType.Model;
        }
        if (shape.getEnumValues() != null) {
            return ShapeType.Enum;
        }
        return null;
    }
}

