/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codegen;

import com.amazonaws.codegen.AddShapes;
import com.amazonaws.codegen.internal.NameUtils;
import com.amazonaws.codegen.internal.Utils;
import com.amazonaws.codegen.model.config.customization.CustomizationConfig;
import com.amazonaws.codegen.model.intermediate.ShapeModel;
import com.amazonaws.codegen.model.intermediate.ShapeType;
import com.amazonaws.codegen.model.service.ErrorMap;
import com.amazonaws.codegen.model.service.ErrorTrait;
import com.amazonaws.codegen.model.service.Operation;
import com.amazonaws.codegen.model.service.ServiceModel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class AddExceptionShapes
extends AddShapes {
    AddExceptionShapes(ServiceModel serviceModel, CustomizationConfig customizationConfig) {
        super(serviceModel, customizationConfig);
    }

    public final Map<String, ShapeModel> constructExceptionShapes() {
        HashMap<String, ShapeModel> javaShapes = new HashMap<String, ShapeModel>();
        for (Map.Entry<String, Operation> entry : this.getServiceModel().getOperations().entrySet()) {
            Operation operation = entry.getValue();
            List<ErrorMap> operationErrors = operation.getErrors();
            if (operationErrors == null) continue;
            for (ErrorMap error : operationErrors) {
                String errorShapeName = error.getShape();
                String javaClassName = NameUtils.getExceptionName(errorShapeName);
                ShapeModel exceptionShapeModel = this.generateShapeModel(javaClassName, errorShapeName);
                exceptionShapeModel.setType(ShapeType.Exception.getValue());
                exceptionShapeModel.setErrorCode(this.getErrorCode(errorShapeName));
                if (exceptionShapeModel.getDocumentation() == null) {
                    exceptionShapeModel.setDocumentation(error.getDocumentation());
                }
                javaShapes.put(javaClassName, exceptionShapeModel);
            }
        }
        return javaShapes;
    }

    private String getErrorCode(String errorShapeName) {
        ErrorTrait errorTrait = this.getServiceModel().getShapes().get(errorShapeName).getErrorTrait();
        if (this.isErrorCodeOverridden(errorTrait)) {
            return errorTrait.getErrorCode();
        }
        return errorShapeName;
    }

    private boolean isErrorCodeOverridden(ErrorTrait errorTrait) {
        return errorTrait != null && !Utils.isNullOrEmpty(errorTrait.getErrorCode());
    }
}

