/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simplesystemsmanagement.model.DocumentDescription;
import com.amazonaws.services.simplesystemsmanagement.model.DocumentParameter;
import com.amazonaws.services.simplesystemsmanagement.model.transform.DocumentParameterJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class DocumentDescriptionJsonMarshaller {
    private static DocumentDescriptionJsonMarshaller instance;

    public void marshall(DocumentDescription documentDescription, JSONWriter jsonWriter) {
        if (documentDescription == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList platformTypesList;
            SdkInternalList parametersList;
            jsonWriter.object();
            if (documentDescription.getSha1() != null) {
                jsonWriter.key("Sha1").value(documentDescription.getSha1());
            }
            if (documentDescription.getName() != null) {
                jsonWriter.key("Name").value(documentDescription.getName());
            }
            if (documentDescription.getCreatedDate() != null) {
                jsonWriter.key("CreatedDate").value(documentDescription.getCreatedDate());
            }
            if (documentDescription.getStatus() != null) {
                jsonWriter.key("Status").value(documentDescription.getStatus());
            }
            if (documentDescription.getDescription() != null) {
                jsonWriter.key("Description").value(documentDescription.getDescription());
            }
            if (!(parametersList = (SdkInternalList)documentDescription.getParameters()).isEmpty() || !parametersList.isAutoConstruct()) {
                jsonWriter.key("Parameters");
                jsonWriter.array();
                for (DocumentParameter parametersListValue : parametersList) {
                    if (parametersListValue == null) continue;
                    DocumentParameterJsonMarshaller.getInstance().marshall(parametersListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (!(platformTypesList = (SdkInternalList)documentDescription.getPlatformTypes()).isEmpty() || !platformTypesList.isAutoConstruct()) {
                jsonWriter.key("PlatformTypes");
                jsonWriter.array();
                for (String platformTypesListValue : platformTypesList) {
                    if (platformTypesListValue == null) continue;
                    jsonWriter.value(platformTypesListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static DocumentDescriptionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new DocumentDescriptionJsonMarshaller();
        }
        return instance;
    }
}

