/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class VpcConfigResponse
implements Serializable,
Cloneable {
    private ListWithAutoConstructFlag<String> subnetIds;
    private ListWithAutoConstructFlag<String> securityGroupIds;
    private String vpcId;

    public List<String> getSubnetIds() {
        if (this.subnetIds == null) {
            this.subnetIds = new ListWithAutoConstructFlag();
            this.subnetIds.setAutoConstruct(true);
        }
        return this.subnetIds;
    }

    public void setSubnetIds(Collection<String> subnetIds) {
        if (subnetIds == null) {
            this.subnetIds = null;
            return;
        }
        ListWithAutoConstructFlag subnetIdsCopy = new ListWithAutoConstructFlag(subnetIds.size());
        subnetIdsCopy.addAll(subnetIds);
        this.subnetIds = subnetIdsCopy;
    }

    public VpcConfigResponse withSubnetIds(String ... subnetIds) {
        if (this.getSubnetIds() == null) {
            this.setSubnetIds(new ArrayList<String>(subnetIds.length));
        }
        for (String value : subnetIds) {
            this.getSubnetIds().add(value);
        }
        return this;
    }

    public VpcConfigResponse withSubnetIds(Collection<String> subnetIds) {
        if (subnetIds == null) {
            this.subnetIds = null;
        } else {
            ListWithAutoConstructFlag subnetIdsCopy = new ListWithAutoConstructFlag(subnetIds.size());
            subnetIdsCopy.addAll(subnetIds);
            this.subnetIds = subnetIdsCopy;
        }
        return this;
    }

    public List<String> getSecurityGroupIds() {
        if (this.securityGroupIds == null) {
            this.securityGroupIds = new ListWithAutoConstructFlag();
            this.securityGroupIds.setAutoConstruct(true);
        }
        return this.securityGroupIds;
    }

    public void setSecurityGroupIds(Collection<String> securityGroupIds) {
        if (securityGroupIds == null) {
            this.securityGroupIds = null;
            return;
        }
        ListWithAutoConstructFlag securityGroupIdsCopy = new ListWithAutoConstructFlag(securityGroupIds.size());
        securityGroupIdsCopy.addAll(securityGroupIds);
        this.securityGroupIds = securityGroupIdsCopy;
    }

    public VpcConfigResponse withSecurityGroupIds(String ... securityGroupIds) {
        if (this.getSecurityGroupIds() == null) {
            this.setSecurityGroupIds(new ArrayList<String>(securityGroupIds.length));
        }
        for (String value : securityGroupIds) {
            this.getSecurityGroupIds().add(value);
        }
        return this;
    }

    public VpcConfigResponse withSecurityGroupIds(Collection<String> securityGroupIds) {
        if (securityGroupIds == null) {
            this.securityGroupIds = null;
        } else {
            ListWithAutoConstructFlag securityGroupIdsCopy = new ListWithAutoConstructFlag(securityGroupIds.size());
            securityGroupIdsCopy.addAll(securityGroupIds);
            this.securityGroupIds = securityGroupIdsCopy;
        }
        return this;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public void setVpcId(String vpcId) {
        this.vpcId = vpcId;
    }

    public VpcConfigResponse withVpcId(String vpcId) {
        this.vpcId = vpcId;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSubnetIds() != null) {
            sb.append("SubnetIds: " + this.getSubnetIds() + ",");
        }
        if (this.getSecurityGroupIds() != null) {
            sb.append("SecurityGroupIds: " + this.getSecurityGroupIds() + ",");
        }
        if (this.getVpcId() != null) {
            sb.append("VpcId: " + this.getVpcId());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSubnetIds() == null ? 0 : this.getSubnetIds().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityGroupIds() == null ? 0 : this.getSecurityGroupIds().hashCode());
        hashCode = 31 * hashCode + (this.getVpcId() == null ? 0 : this.getVpcId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcConfigResponse)) {
            return false;
        }
        VpcConfigResponse other = (VpcConfigResponse)obj;
        if (other.getSubnetIds() == null ^ this.getSubnetIds() == null) {
            return false;
        }
        if (other.getSubnetIds() != null && !other.getSubnetIds().equals(this.getSubnetIds())) {
            return false;
        }
        if (other.getSecurityGroupIds() == null ^ this.getSecurityGroupIds() == null) {
            return false;
        }
        if (other.getSecurityGroupIds() != null && !other.getSecurityGroupIds().equals(this.getSecurityGroupIds())) {
            return false;
        }
        if (other.getVpcId() == null ^ this.getVpcId() == null) {
            return false;
        }
        return other.getVpcId() == null || other.getVpcId().equals(this.getVpcId());
    }

    public VpcConfigResponse clone() {
        try {
            return (VpcConfigResponse)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

