/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.gamelift.model.DescribeFleetUtilizationRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.List;

public class DescribeFleetUtilizationRequestMarshaller
implements Marshaller<Request<DescribeFleetUtilizationRequest>, DescribeFleetUtilizationRequest> {
    @Override
    public Request<DescribeFleetUtilizationRequest> marshall(DescribeFleetUtilizationRequest describeFleetUtilizationRequest) {
        if (describeFleetUtilizationRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeFleetUtilizationRequest> request = new DefaultRequest<DescribeFleetUtilizationRequest>(describeFleetUtilizationRequest, "AmazonGameLift");
        request.addHeader("X-Amz-Target", "GameLift.DescribeFleetUtilization");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            List<String> fleetIdsList = describeFleetUtilizationRequest.getFleetIds();
            if (fleetIdsList != null) {
                jsonWriter.key("FleetIds");
                jsonWriter.array();
                for (String fleetIdsListValue : fleetIdsList) {
                    if (fleetIdsListValue == null) continue;
                    jsonWriter.value(fleetIdsListValue);
                }
                jsonWriter.endArray();
            }
            if (describeFleetUtilizationRequest.getLimit() != null) {
                jsonWriter.key("Limit").value(describeFleetUtilizationRequest.getLimit());
            }
            if (describeFleetUtilizationRequest.getNextToken() != null) {
                jsonWriter.key("NextToken").value(describeFleetUtilizationRequest.getNextToken());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

