/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devicefarm.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.devicefarm.model.AccountSettings;
import com.amazonaws.util.json.JSONWriter;
import java.util.Map;

public class AccountSettingsJsonMarshaller {
    private static AccountSettingsJsonMarshaller instance;

    public void marshall(AccountSettings accountSettings, JSONWriter jsonWriter) {
        if (accountSettings == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            Map<String, Integer> unmeteredDevicesMap;
            jsonWriter.object();
            if (accountSettings.getAwsAccountNumber() != null) {
                jsonWriter.key("awsAccountNumber").value(accountSettings.getAwsAccountNumber());
            }
            if ((unmeteredDevicesMap = accountSettings.getUnmeteredDevices()) != null) {
                jsonWriter.key("unmeteredDevices");
                jsonWriter.object();
                for (Map.Entry<String, Integer> unmeteredDevicesMapValue : unmeteredDevicesMap.entrySet()) {
                    if (unmeteredDevicesMapValue.getValue() == null) continue;
                    jsonWriter.key(unmeteredDevicesMapValue.getKey());
                    jsonWriter.value(unmeteredDevicesMapValue.getValue());
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static AccountSettingsJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new AccountSettingsJsonMarshaller();
        }
        return instance;
    }
}

