/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.storagegateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.storagegateway.model.DescribeTapeArchivesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class DescribeTapeArchivesRequestMarshaller
implements Marshaller<Request<DescribeTapeArchivesRequest>, DescribeTapeArchivesRequest> {
    @Override
    public Request<DescribeTapeArchivesRequest> marshall(DescribeTapeArchivesRequest describeTapeArchivesRequest) {
        if (describeTapeArchivesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeTapeArchivesRequest> request = new DefaultRequest<DescribeTapeArchivesRequest>(describeTapeArchivesRequest, "AWSStorageGateway");
        request.addHeader("X-Amz-Target", "StorageGateway_20130630.DescribeTapeArchives");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            SdkInternalList tapeARNsList = (SdkInternalList)describeTapeArchivesRequest.getTapeARNs();
            if (!tapeARNsList.isEmpty() || !tapeARNsList.isAutoConstruct()) {
                jsonWriter.key("TapeARNs");
                jsonWriter.array();
                for (String tapeARNsListValue : tapeARNsList) {
                    if (tapeARNsListValue == null) continue;
                    jsonWriter.value(tapeARNsListValue);
                }
                jsonWriter.endArray();
            }
            if (describeTapeArchivesRequest.getMarker() != null) {
                jsonWriter.key("Marker").value(describeTapeArchivesRequest.getMarker());
            }
            if (describeTapeArchivesRequest.getLimit() != null) {
                jsonWriter.key("Limit").value(describeTapeArchivesRequest.getLimit());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

