/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simplesystemsmanagement.model.CommandInvocationStatus;
import com.amazonaws.services.simplesystemsmanagement.model.CommandPlugin;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class CommandInvocation
implements Serializable,
Cloneable {
    private String commandId;
    private String instanceId;
    private String comment;
    private String documentName;
    private Date requestedDateTime;
    private String status;
    private String traceOutput;
    private SdkInternalList<CommandPlugin> commandPlugins;

    public void setCommandId(String commandId) {
        this.commandId = commandId;
    }

    public String getCommandId() {
        return this.commandId;
    }

    public CommandInvocation withCommandId(String commandId) {
        this.setCommandId(commandId);
        return this;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public CommandInvocation withInstanceId(String instanceId) {
        this.setInstanceId(instanceId);
        return this;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getComment() {
        return this.comment;
    }

    public CommandInvocation withComment(String comment) {
        this.setComment(comment);
        return this;
    }

    public void setDocumentName(String documentName) {
        this.documentName = documentName;
    }

    public String getDocumentName() {
        return this.documentName;
    }

    public CommandInvocation withDocumentName(String documentName) {
        this.setDocumentName(documentName);
        return this;
    }

    public void setRequestedDateTime(Date requestedDateTime) {
        this.requestedDateTime = requestedDateTime;
    }

    public Date getRequestedDateTime() {
        return this.requestedDateTime;
    }

    public CommandInvocation withRequestedDateTime(Date requestedDateTime) {
        this.setRequestedDateTime(requestedDateTime);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public CommandInvocation withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public void setStatus(CommandInvocationStatus status) {
        this.status = status.toString();
    }

    public CommandInvocation withStatus(CommandInvocationStatus status) {
        this.setStatus(status);
        return this;
    }

    public void setTraceOutput(String traceOutput) {
        this.traceOutput = traceOutput;
    }

    public String getTraceOutput() {
        return this.traceOutput;
    }

    public CommandInvocation withTraceOutput(String traceOutput) {
        this.setTraceOutput(traceOutput);
        return this;
    }

    public List<CommandPlugin> getCommandPlugins() {
        if (this.commandPlugins == null) {
            this.commandPlugins = new SdkInternalList();
        }
        return this.commandPlugins;
    }

    public void setCommandPlugins(Collection<CommandPlugin> commandPlugins) {
        if (commandPlugins == null) {
            this.commandPlugins = null;
            return;
        }
        this.commandPlugins = new SdkInternalList<CommandPlugin>(commandPlugins);
    }

    public CommandInvocation withCommandPlugins(CommandPlugin ... commandPlugins) {
        if (this.commandPlugins == null) {
            this.setCommandPlugins(new SdkInternalList<CommandPlugin>(commandPlugins.length));
        }
        for (CommandPlugin ele : commandPlugins) {
            this.commandPlugins.add(ele);
        }
        return this;
    }

    public CommandInvocation withCommandPlugins(Collection<CommandPlugin> commandPlugins) {
        this.setCommandPlugins(commandPlugins);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCommandId() != null) {
            sb.append("CommandId: " + this.getCommandId() + ",");
        }
        if (this.getInstanceId() != null) {
            sb.append("InstanceId: " + this.getInstanceId() + ",");
        }
        if (this.getComment() != null) {
            sb.append("Comment: " + this.getComment() + ",");
        }
        if (this.getDocumentName() != null) {
            sb.append("DocumentName: " + this.getDocumentName() + ",");
        }
        if (this.getRequestedDateTime() != null) {
            sb.append("RequestedDateTime: " + this.getRequestedDateTime() + ",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: " + this.getStatus() + ",");
        }
        if (this.getTraceOutput() != null) {
            sb.append("TraceOutput: " + this.getTraceOutput() + ",");
        }
        if (this.getCommandPlugins() != null) {
            sb.append("CommandPlugins: " + this.getCommandPlugins());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CommandInvocation)) {
            return false;
        }
        CommandInvocation other = (CommandInvocation)obj;
        if (other.getCommandId() == null ^ this.getCommandId() == null) {
            return false;
        }
        if (other.getCommandId() != null && !other.getCommandId().equals(this.getCommandId())) {
            return false;
        }
        if (other.getInstanceId() == null ^ this.getInstanceId() == null) {
            return false;
        }
        if (other.getInstanceId() != null && !other.getInstanceId().equals(this.getInstanceId())) {
            return false;
        }
        if (other.getComment() == null ^ this.getComment() == null) {
            return false;
        }
        if (other.getComment() != null && !other.getComment().equals(this.getComment())) {
            return false;
        }
        if (other.getDocumentName() == null ^ this.getDocumentName() == null) {
            return false;
        }
        if (other.getDocumentName() != null && !other.getDocumentName().equals(this.getDocumentName())) {
            return false;
        }
        if (other.getRequestedDateTime() == null ^ this.getRequestedDateTime() == null) {
            return false;
        }
        if (other.getRequestedDateTime() != null && !other.getRequestedDateTime().equals(this.getRequestedDateTime())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getTraceOutput() == null ^ this.getTraceOutput() == null) {
            return false;
        }
        if (other.getTraceOutput() != null && !other.getTraceOutput().equals(this.getTraceOutput())) {
            return false;
        }
        if (other.getCommandPlugins() == null ^ this.getCommandPlugins() == null) {
            return false;
        }
        return other.getCommandPlugins() == null || other.getCommandPlugins().equals(this.getCommandPlugins());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCommandId() == null ? 0 : this.getCommandId().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceId() == null ? 0 : this.getInstanceId().hashCode());
        hashCode = 31 * hashCode + (this.getComment() == null ? 0 : this.getComment().hashCode());
        hashCode = 31 * hashCode + (this.getDocumentName() == null ? 0 : this.getDocumentName().hashCode());
        hashCode = 31 * hashCode + (this.getRequestedDateTime() == null ? 0 : this.getRequestedDateTime().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getTraceOutput() == null ? 0 : this.getTraceOutput().hashCode());
        hashCode = 31 * hashCode + (this.getCommandPlugins() == null ? 0 : this.getCommandPlugins().hashCode());
        return hashCode;
    }

    public CommandInvocation clone() {
        try {
            return (CommandInvocation)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

