/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.iot.model.DisableTopicRuleRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class DisableTopicRuleRequestMarshaller
implements Marshaller<Request<DisableTopicRuleRequest>, DisableTopicRuleRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<DisableTopicRuleRequest> marshall(DisableTopicRuleRequest disableTopicRuleRequest) {
        if (disableTopicRuleRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DisableTopicRuleRequest> request = new DefaultRequest<DisableTopicRuleRequest>(disableTopicRuleRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/rules/{ruleName}/disable";
        uriResourcePath = uriResourcePath.replace("{ruleName}", disableTopicRuleRequest.getRuleName() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString(disableTopicRuleRequest.getRuleName()));
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

