/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.dynamodbv2.datamodeling.ArgumentMarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.ArgumentUnmarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAttribute;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAutoGeneratedKey;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAutoGeneratorRegistry;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBDocument;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBHashKey;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBIgnore;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBIndexHashKey;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBIndexRangeKey;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMarshalling;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBNativeBoolean;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBRangeKey;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTable;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBVersionAttribute;
import com.amazonaws.services.dynamodbv2.datamodeling.ReflectionUtils;
import com.amazonaws.services.dynamodbv2.datamodeling.marshallers.BooleanToBooleanMarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.marshallers.CustomMarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.unmarshallers.CustomUnmarshaller;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@SdkInternalApi
final class DynamoDBMappingsRegistry {
    private static final Log log = LogFactory.getLog(DynamoDBMappingsRegistry.class);
    private static final DynamoDBMappingsRegistry INSTANCE = new DynamoDBMappingsRegistry();
    private final ConcurrentMap<Class<?>, Mappings> mappings = new ConcurrentHashMap();

    DynamoDBMappingsRegistry() {
    }

    static final DynamoDBMappingsRegistry instance() {
        return INSTANCE;
    }

    final Mappings mappingsOf(Class<?> clazz) {
        if (!this.mappings.containsKey(clazz)) {
            Mappings result = new Mappings(clazz);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Created new mappings: " + result));
            }
            this.mappings.putIfAbsent(clazz, result);
        }
        return (Mappings)this.mappings.get(clazz);
    }

    final Mapping mappingOf(Method method) {
        return this.mappingsOf(method.getDeclaringClass()).getMapping(method);
    }

    static final class Mapping {
        private static final Collection<Class<? extends Annotation>> ANNOTATION_TYPES = Arrays.asList(DynamoDBHashKey.class, DynamoDBRangeKey.class, DynamoDBIndexHashKey.class, DynamoDBIndexRangeKey.class, DynamoDBAttribute.class, DynamoDBVersionAttribute.class, DynamoDBAutoGeneratedKey.class, DynamoDBMarshalling.class, DynamoDBNativeBoolean.class);
        private final Method getter;
        private final Method setter;
        private final Class<?> getterType;
        private final Class<?> setterType;
        private final Map<Class<? extends Annotation>, Annotation> annotations;
        private final DynamoDBAutoGeneratorRegistry.Generator<Object> autoGenerator;
        private final String attributeName;

        private Mapping(Method getterMethod) {
            this.getter = getterMethod;
            this.setter = ReflectionUtils.getDeclaredSetterByGetter(getterMethod);
            this.getterType = getterMethod.getReturnType();
            this.setterType = this.setter == null || this.setter.getParameterTypes().length != 1 ? Object.class : this.setter.getParameterTypes()[0];
            this.annotations = new HashMap<Class<? extends Annotation>, Annotation>();
            for (Class<? extends Annotation> annotationType : ANNOTATION_TYPES) {
                Annotation annotation = ReflectionUtils.getAnnotationFromGetterOrField(getterMethod, annotationType);
                if (annotation == null) continue;
                this.annotations.put(annotationType, annotation);
            }
            this.autoGenerator = this.isAutoGeneratedKey() ? DynamoDBAutoGeneratorRegistry.instance().generatorOf(DynamoDBAutoGeneratorRegistry.Generators.KEY, this.getGetterType()) : (this.isVersion() ? DynamoDBAutoGeneratorRegistry.instance().generatorOf(DynamoDBAutoGeneratorRegistry.Generators.VERSION, this.getGetterType()) : DynamoDBAutoGeneratorRegistry.instance().generatorOf(DynamoDBAutoGeneratorRegistry.Generators.NEVER, this.getGetterType()));
            this.attributeName = this.isHashKey() && !this.getAnnotation(DynamoDBHashKey.class).attributeName().isEmpty() ? this.getAnnotation(DynamoDBHashKey.class).attributeName() : (this.isIndexHashKey() && !this.getAnnotation(DynamoDBIndexHashKey.class).attributeName().isEmpty() ? this.getAnnotation(DynamoDBIndexHashKey.class).attributeName() : (this.isRangeKey() && !this.getAnnotation(DynamoDBRangeKey.class).attributeName().isEmpty() ? this.getAnnotation(DynamoDBRangeKey.class).attributeName() : (this.isIndexRangeKey() && !this.getAnnotation(DynamoDBIndexRangeKey.class).attributeName().isEmpty() ? this.getAnnotation(DynamoDBIndexRangeKey.class).attributeName() : (this.getAnnotation(DynamoDBAttribute.class) != null && !this.getAnnotation(DynamoDBAttribute.class).attributeName().isEmpty() ? this.getAnnotation(DynamoDBAttribute.class).attributeName() : (this.isVersion() && !this.getAnnotation(DynamoDBVersionAttribute.class).attributeName().isEmpty() ? this.getAnnotation(DynamoDBVersionAttribute.class).attributeName() : ReflectionUtils.getFieldNameByGetter(getterMethod, true))))));
        }

        final Method getter() {
            return this.getter;
        }

        final Method setter() {
            if (this.setter == null) {
                throw new DynamoDBMappingException("No access to public, one-argument method called set" + ReflectionUtils.getFieldNameByGetter(this.getter(), false) + " on class " + this.getter().getDeclaringClass());
            }
            return this.setter;
        }

        final String getAttributeName() {
            return this.attributeName;
        }

        final <T extends Annotation> T getAnnotation(Class<T> clazz) {
            return (T)this.annotations.get(clazz);
        }

        final Class<?> getGetterType() {
            return this.getterType;
        }

        final Class<?> getSetterType() {
            return this.setterType;
        }

        final Object getValueOf(Object target) {
            try {
                return this.getter().invoke(target, new Object[0]);
            }
            catch (Exception e) {
                throw new DynamoDBMappingException("Couldn't invoke " + this.getter() + " on " + target.getClass(), e);
            }
        }

        final void setValueOf(Object target, Object value) {
            Method method = this.setter();
            try {
                method.invoke(target, value);
            }
            catch (Exception e) {
                throw new DynamoDBMappingException("Couldn't invoke " + method + " on " + target.getClass(), e);
            }
        }

        final boolean isPrimaryKey() {
            return this.isHashKey() || this.isRangeKey();
        }

        final boolean isHashKey() {
            return this.annotations.containsKey(DynamoDBHashKey.class);
        }

        final boolean isRangeKey() {
            return this.annotations.containsKey(DynamoDBRangeKey.class);
        }

        final boolean isIndexHashKey() {
            return this.annotations.containsKey(DynamoDBIndexHashKey.class);
        }

        final boolean isIndexRangeKey() {
            return this.annotations.containsKey(DynamoDBIndexRangeKey.class);
        }

        final boolean isVersion() {
            return this.annotations.containsKey(DynamoDBVersionAttribute.class);
        }

        final boolean isAutoGeneratedKey() {
            if (!(this.isHashKey() || this.isRangeKey() || this.isIndexHashKey() || this.isIndexRangeKey())) {
                return false;
            }
            return this.annotations.containsKey(DynamoDBAutoGeneratedKey.class);
        }

        final DynamoDBAutoGeneratorRegistry.Generator<Object> getAutoGenerator() {
            return this.autoGenerator;
        }

        final ArgumentMarshaller getCustomMarshaller() {
            if (this.getAnnotation(DynamoDBMarshalling.class) != null) {
                DynamoDBMarshalling annotation = this.getAnnotation(DynamoDBMarshalling.class);
                return new CustomMarshaller(annotation.marshallerClass());
            }
            if (this.getAnnotation(DynamoDBNativeBoolean.class) != null) {
                return BooleanToBooleanMarshaller.instance();
            }
            return null;
        }

        final ArgumentUnmarshaller getCustomUnmarshaller() {
            if (this.getAnnotation(DynamoDBMarshalling.class) != null) {
                DynamoDBMarshalling annotation = this.getAnnotation(DynamoDBMarshalling.class);
                return new CustomUnmarshaller(this.getGetterType(), annotation.marshallerClass());
            }
            return null;
        }

        public final String toString() {
            StringBuilder result = new StringBuilder().append(this.getClass().getSimpleName());
            result.append("{attributeName=").append(this.attributeName);
            result.append(",getter=").append(this.getter);
            result.append(",setter=").append(this.setter);
            result.append(",getterType=").append(this.getterType);
            result.append(",setterType=").append(this.setterType);
            result.append(",annotations=").append(this.annotations);
            result.append(",autoGenerator=").append(this.autoGenerator);
            result.append("}");
            return result.toString();
        }
    }

    static final class Mappings {
        private static final Collection<Class<? extends Annotation>> ANNOTATION_TYPES = Arrays.asList(DynamoDBTable.class, DynamoDBDocument.class);
        private final Class<?> objectType;
        private final Map<Class<? extends Annotation>, Annotation> annotations;
        private final Map<Class<? extends Annotation>, Mapping> byTypes;
        private final Map<String, Mapping> byNames;
        private final Map<Method, Mapping> byGetters;
        private final Collection<Mapping> primaryKeys;

        private static final boolean isMappable(Class<?> clazz) {
            for (Class<? extends Annotation> annotationType : ANNOTATION_TYPES) {
                if (!clazz.isAnnotationPresent(annotationType)) continue;
                return true;
            }
            return false;
        }

        private Mappings(Class<?> clazz) {
            this.objectType = clazz;
            this.annotations = new HashMap<Class<? extends Annotation>, Annotation>();
            for (Class<? extends Annotation> annotationType : ANNOTATION_TYPES) {
                Annotation annotation = clazz.getAnnotation(annotationType);
                if (annotation == null) continue;
                this.annotations.put(annotationType, annotation);
            }
            Method[] methods = clazz.getMethods();
            this.byTypes = new HashMap<Class<? extends Annotation>, Mapping>();
            this.byNames = new HashMap<String, Mapping>();
            this.byGetters = new HashMap<Method, Mapping>();
            this.primaryKeys = new HashSet<Mapping>(4);
            for (Method m : clazz.getMethods()) {
                if (!m.getName().startsWith("get") && !m.getName().startsWith("is") || m.getParameterTypes().length != 0 || m.isBridge() || m.isSynthetic() || !Mappings.isMappable(m.getDeclaringClass()) || ReflectionUtils.getAnnotationFromGetterOrField(m, DynamoDBIgnore.class) != null) continue;
                Mapping mapping = new Mapping(m);
                if (this.byNames.containsKey(mapping.getAttributeName())) {
                    throw new DynamoDBMappingException("Class " + clazz.getName() + " maps duplicate attributes named " + mapping.getAttributeName());
                }
                this.byNames.put(mapping.getAttributeName(), mapping);
                this.byGetters.put(m, mapping);
                if (mapping.isHashKey()) {
                    if (this.byTypes.containsKey(DynamoDBHashKey.class)) {
                        throw new DynamoDBMappingException("Class " + clazz.getName() + " maps @DynamoDBHashKey to multiple attributes");
                    }
                    this.byTypes.put(DynamoDBHashKey.class, mapping);
                    this.primaryKeys.add(mapping);
                }
                if (mapping.isRangeKey()) {
                    if (this.byTypes.containsKey(DynamoDBRangeKey.class)) {
                        throw new DynamoDBMappingException("Class " + clazz.getName() + " maps @DynamoDBRangeKey to multiple attributes");
                    }
                    this.byTypes.put(DynamoDBRangeKey.class, mapping);
                    this.primaryKeys.add(mapping);
                }
                if (!mapping.isVersion()) continue;
                if (this.byTypes.containsKey(DynamoDBVersionAttribute.class)) {
                    log.warn((Object)("Class " + clazz.getName() + " maps @DynamoDBVersionAttribute to multiple attributes"));
                }
                this.byTypes.put(DynamoDBVersionAttribute.class, mapping);
            }
            if (this.getAnnotation(DynamoDBTable.class) != null && !this.byTypes.containsKey(DynamoDBHashKey.class)) {
                log.warn((Object)("Class " + clazz.getName() + " does not map a @DynamoDBHashKey attribute"));
            }
        }

        final Class<?> getObjectType() {
            return this.objectType;
        }

        final <T extends Annotation> T getAnnotation(Class<T> clazz) {
            return (T)this.annotations.get(clazz);
        }

        final Collection<Mapping> getMappings() {
            return this.byNames.values();
        }

        final Mapping getMapping(Method method) {
            Mapping mapping = this.byGetters.get(method);
            if (mapping == null) {
                throw new DynamoDBMappingException("Class " + this.getObjectType().getName() + " does not map any getter named " + method.getName());
            }
            return mapping;
        }

        final Collection<Mapping> getPrimaryKeys() {
            return this.primaryKeys;
        }

        final Mapping getHashKey() {
            Mapping mapping = this.byTypes.get(DynamoDBHashKey.class);
            if (mapping == null) {
                throw new DynamoDBMappingException("Class " + this.getObjectType().getName() + " does not map a @DynamoDBHashKey attribute" + "; ensure a public, zero-parameter get method/field is annotated");
            }
            return mapping;
        }

        final boolean hasRangeKey() {
            return this.byTypes.containsKey(DynamoDBRangeKey.class);
        }

        final Mapping getRangeKey() {
            return this.byTypes.get(DynamoDBRangeKey.class);
        }

        final boolean hasVersion() {
            return this.byTypes.containsKey(DynamoDBVersionAttribute.class);
        }

        final Mapping getVersion() {
            return this.byTypes.get(DynamoDBVersionAttribute.class);
        }

        final String getTableName() {
            DynamoDBTable annotation = this.getAnnotation(DynamoDBTable.class);
            if (annotation == null) {
                throw new DynamoDBMappingException("Class " + this.getObjectType() + " must be annotated with " + DynamoDBTable.class);
            }
            return annotation.tableName();
        }

        public final String toString() {
            StringBuilder result = new StringBuilder().append(this.getClass().getSimpleName());
            result.append("{objectType=").append(this.objectType);
            result.append(",annotations=").append(this.annotations);
            result.append(",byTypes=").append(this.byTypes);
            result.append(",byNames=").append(this.byNames);
            result.append(",byGetters=").append(this.byGetters);
            result.append(",primaryKeys=").append(this.primaryKeys);
            result.append("}");
            return result.toString();
        }
    }
}

