/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directconnect.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.directconnect.model.Connection;
import com.amazonaws.util.json.JSONWriter;

public class ConnectionJsonMarshaller {
    private static ConnectionJsonMarshaller instance;

    public void marshall(Connection connection, JSONWriter jsonWriter) {
        if (connection == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (connection.getOwnerAccount() != null) {
                jsonWriter.key("ownerAccount").value(connection.getOwnerAccount());
            }
            if (connection.getConnectionId() != null) {
                jsonWriter.key("connectionId").value(connection.getConnectionId());
            }
            if (connection.getConnectionName() != null) {
                jsonWriter.key("connectionName").value(connection.getConnectionName());
            }
            if (connection.getConnectionState() != null) {
                jsonWriter.key("connectionState").value(connection.getConnectionState());
            }
            if (connection.getRegion() != null) {
                jsonWriter.key("region").value(connection.getRegion());
            }
            if (connection.getLocation() != null) {
                jsonWriter.key("location").value(connection.getLocation());
            }
            if (connection.getBandwidth() != null) {
                jsonWriter.key("bandwidth").value(connection.getBandwidth());
            }
            if (connection.getVlan() != null) {
                jsonWriter.key("vlan").value(connection.getVlan());
            }
            if (connection.getPartnerName() != null) {
                jsonWriter.key("partnerName").value(connection.getPartnerName());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ConnectionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ConnectionJsonMarshaller();
        }
        return instance;
    }
}

