/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.apigateway.model.Method;
import com.amazonaws.services.apigateway.model.Resource;
import com.amazonaws.services.apigateway.model.transform.MethodJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;
import java.util.Map;

public class ResourceJsonMarshaller {
    private static ResourceJsonMarshaller instance;

    public void marshall(Resource resource, JSONWriter jsonWriter) {
        if (resource == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            Map<String, Method> resourceMethodsMap;
            jsonWriter.object();
            if (resource.getId() != null) {
                jsonWriter.key("id").value(resource.getId());
            }
            if (resource.getParentId() != null) {
                jsonWriter.key("parentId").value(resource.getParentId());
            }
            if (resource.getPathPart() != null) {
                jsonWriter.key("pathPart").value(resource.getPathPart());
            }
            if (resource.getPath() != null) {
                jsonWriter.key("path").value(resource.getPath());
            }
            if ((resourceMethodsMap = resource.getResourceMethods()) != null) {
                jsonWriter.key("resourceMethods");
                jsonWriter.object();
                for (Map.Entry<String, Method> resourceMethodsMapValue : resourceMethodsMap.entrySet()) {
                    if (resourceMethodsMapValue.getValue() == null) continue;
                    jsonWriter.key(resourceMethodsMapValue.getKey());
                    MethodJsonMarshaller.getInstance().marshall(resourceMethodsMapValue.getValue(), jsonWriter);
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ResourceJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ResourceJsonMarshaller();
        }
        return instance;
    }
}

