/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.route53.model.GetGeoLocationRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class GetGeoLocationRequestMarshaller
implements Marshaller<Request<GetGeoLocationRequest>, GetGeoLocationRequest> {
    @Override
    public Request<GetGeoLocationRequest> marshall(GetGeoLocationRequest getGeoLocationRequest) {
        String subdivisionCode;
        String countryCode;
        String continentCode;
        if (getGeoLocationRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetGeoLocationRequest> request = new DefaultRequest<GetGeoLocationRequest>(getGeoLocationRequest, "AmazonRoute53");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2013-04-01/geolocation";
        request.setResourcePath(uriResourcePath);
        String string = continentCode = getGeoLocationRequest.getContinentCode() == null ? null : StringUtils.fromString(getGeoLocationRequest.getContinentCode());
        if (continentCode != null) {
            request.addParameter("continentcode", continentCode);
        }
        String string2 = countryCode = getGeoLocationRequest.getCountryCode() == null ? null : StringUtils.fromString(getGeoLocationRequest.getCountryCode());
        if (countryCode != null) {
            request.addParameter("countrycode", countryCode);
        }
        String string3 = subdivisionCode = getGeoLocationRequest.getSubdivisionCode() == null ? null : StringUtils.fromString(getGeoLocationRequest.getSubdivisionCode());
        if (subdivisionCode != null) {
            request.addParameter("subdivisioncode", subdivisionCode);
        }
        return request;
    }
}

