/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticsearch.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.elasticsearch.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AddTagsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String aRN;
    private List<Tag> tagList;

    public void setARN(String aRN) {
        this.aRN = aRN;
    }

    public String getARN() {
        return this.aRN;
    }

    public AddTagsRequest withARN(String aRN) {
        this.setARN(aRN);
        return this;
    }

    public List<Tag> getTagList() {
        return this.tagList;
    }

    public void setTagList(Collection<Tag> tagList) {
        if (tagList == null) {
            this.tagList = null;
            return;
        }
        this.tagList = new ArrayList<Tag>(tagList);
    }

    public AddTagsRequest withTagList(Tag ... tagList) {
        if (this.tagList == null) {
            this.setTagList(new ArrayList<Tag>(tagList.length));
        }
        for (Tag ele : tagList) {
            this.tagList.add(ele);
        }
        return this;
    }

    public AddTagsRequest withTagList(Collection<Tag> tagList) {
        this.setTagList(tagList);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getARN() != null) {
            sb.append("ARN: " + this.getARN() + ",");
        }
        if (this.getTagList() != null) {
            sb.append("TagList: " + this.getTagList());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddTagsRequest)) {
            return false;
        }
        AddTagsRequest other = (AddTagsRequest)obj;
        if (other.getARN() == null ^ this.getARN() == null) {
            return false;
        }
        if (other.getARN() != null && !other.getARN().equals(this.getARN())) {
            return false;
        }
        if (other.getTagList() == null ^ this.getTagList() == null) {
            return false;
        }
        return other.getTagList() == null || other.getTagList().equals(this.getTagList());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getARN() == null ? 0 : this.getARN().hashCode());
        hashCode = 31 * hashCode + (this.getTagList() == null ? 0 : this.getTagList().hashCode());
        return hashCode;
    }

    @Override
    public AddTagsRequest clone() {
        return (AddTagsRequest)super.clone();
    }
}

