/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecr.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.ecr.model.ImageFailure;
import com.amazonaws.services.ecr.model.transform.ImageIdentifierJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class ImageFailureJsonMarshaller {
    private static ImageFailureJsonMarshaller instance;

    public void marshall(ImageFailure imageFailure, JSONWriter jsonWriter) {
        if (imageFailure == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (imageFailure.getImageId() != null) {
                jsonWriter.key("imageId");
                ImageIdentifierJsonMarshaller.getInstance().marshall(imageFailure.getImageId(), jsonWriter);
            }
            if (imageFailure.getFailureCode() != null) {
                jsonWriter.key("failureCode").value(imageFailure.getFailureCode());
            }
            if (imageFailure.getFailureReason() != null) {
                jsonWriter.key("failureReason").value(imageFailure.getFailureReason());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ImageFailureJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ImageFailureJsonMarshaller();
        }
        return instance;
    }
}

