/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.directory.model.Attribute;
import com.amazonaws.services.directory.model.CreateComputerRequest;
import com.amazonaws.services.directory.model.transform.AttributeJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class CreateComputerRequestMarshaller
implements Marshaller<Request<CreateComputerRequest>, CreateComputerRequest> {
    @Override
    public Request<CreateComputerRequest> marshall(CreateComputerRequest createComputerRequest) {
        if (createComputerRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateComputerRequest> request = new DefaultRequest<CreateComputerRequest>(createComputerRequest, "AWSDirectoryService");
        request.addHeader("X-Amz-Target", "DirectoryService_20150416.CreateComputer");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList computerAttributesList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (createComputerRequest.getDirectoryId() != null) {
                jsonWriter.key("DirectoryId").value(createComputerRequest.getDirectoryId());
            }
            if (createComputerRequest.getComputerName() != null) {
                jsonWriter.key("ComputerName").value(createComputerRequest.getComputerName());
            }
            if (createComputerRequest.getPassword() != null) {
                jsonWriter.key("Password").value(createComputerRequest.getPassword());
            }
            if (createComputerRequest.getOrganizationalUnitDistinguishedName() != null) {
                jsonWriter.key("OrganizationalUnitDistinguishedName").value(createComputerRequest.getOrganizationalUnitDistinguishedName());
            }
            if (!(computerAttributesList = (SdkInternalList)createComputerRequest.getComputerAttributes()).isEmpty() || !computerAttributesList.isAutoConstruct()) {
                jsonWriter.key("ComputerAttributes");
                jsonWriter.array();
                for (Attribute computerAttributesListValue : computerAttributesList) {
                    if (computerAttributesListValue == null) continue;
                    AttributeJsonMarshaller.getInstance().marshall(computerAttributesListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

