/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitosync.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitosync.model.BulkPublishRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class BulkPublishRequestMarshaller
implements Marshaller<Request<BulkPublishRequest>, BulkPublishRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "application/x-amz-json-1.1";

    @Override
    public Request<BulkPublishRequest> marshall(BulkPublishRequest bulkPublishRequest) {
        if (bulkPublishRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<BulkPublishRequest> request = new DefaultRequest<BulkPublishRequest>(bulkPublishRequest, "AmazonCognitoSync");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/identitypools/{IdentityPoolId}/bulkpublish";
        uriResourcePath = uriResourcePath.replace("{IdentityPoolId}", bulkPublishRequest.getIdentityPoolId() == null ? "" : StringUtils.fromString(bulkPublishRequest.getIdentityPoolId()));
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

