/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatchevents.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudwatchevents.model.PutTargetsRequest;
import com.amazonaws.services.cloudwatchevents.model.Target;
import com.amazonaws.services.cloudwatchevents.model.transform.TargetJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.List;

public class PutTargetsRequestMarshaller
implements Marshaller<Request<PutTargetsRequest>, PutTargetsRequest> {
    @Override
    public Request<PutTargetsRequest> marshall(PutTargetsRequest putTargetsRequest) {
        if (putTargetsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PutTargetsRequest> request = new DefaultRequest<PutTargetsRequest>(putTargetsRequest, "AmazonCloudWatchEvents");
        request.addHeader("X-Amz-Target", "AWSEvents.PutTargets");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<Target> targetsList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (putTargetsRequest.getRule() != null) {
                jsonWriter.key("Rule").value(putTargetsRequest.getRule());
            }
            if ((targetsList = putTargetsRequest.getTargets()) != null) {
                jsonWriter.key("Targets");
                jsonWriter.array();
                for (Target targetsListValue : targetsList) {
                    if (targetsListValue == null) continue;
                    TargetJsonMarshaller.getInstance().marshall(targetsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

