/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudsearchdomain.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudsearchdomain.model.Hit;
import com.amazonaws.services.cloudsearchdomain.model.Hits;
import com.amazonaws.services.cloudsearchdomain.model.transform.HitJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class HitsJsonMarshaller {
    private static HitsJsonMarshaller instance;

    public void marshall(Hits hits, JSONWriter jsonWriter) {
        if (hits == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList hitList;
            jsonWriter.object();
            if (hits.getFound() != null) {
                jsonWriter.key("found").value(hits.getFound());
            }
            if (hits.getStart() != null) {
                jsonWriter.key("start").value(hits.getStart());
            }
            if (hits.getCursor() != null) {
                jsonWriter.key("cursor").value(hits.getCursor());
            }
            if (!(hitList = (SdkInternalList)hits.getHit()).isEmpty() || !hitList.isAutoConstruct()) {
                jsonWriter.key("hit");
                jsonWriter.array();
                for (Hit hitListValue : hitList) {
                    if (hitListValue == null) continue;
                    HitJsonMarshaller.getInstance().marshall(hitListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static HitsJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new HitsJsonMarshaller();
        }
        return instance;
    }
}

