/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.PutIntegrationRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;

public class PutIntegrationRequestMarshaller
implements Marshaller<Request<PutIntegrationRequest>, PutIntegrationRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<PutIntegrationRequest> marshall(PutIntegrationRequest putIntegrationRequest) {
        if (putIntegrationRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PutIntegrationRequest> request = new DefaultRequest<PutIntegrationRequest>(putIntegrationRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.PUT);
        String uriResourcePath = "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/integration";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", putIntegrationRequest.getRestApiId() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString(putIntegrationRequest.getRestApiId()));
        uriResourcePath = uriResourcePath.replace("{resource_id}", putIntegrationRequest.getResourceId() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString(putIntegrationRequest.getResourceId()));
        uriResourcePath = uriResourcePath.replace("{http_method}", putIntegrationRequest.getHttpMethod() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString(putIntegrationRequest.getHttpMethod()));
        request.setResourcePath(uriResourcePath);
        try {
            List<String> cacheKeyParametersList;
            Map<String, String> requestTemplatesMap;
            Map<String, String> requestParametersMap;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (putIntegrationRequest.getType() != null) {
                jsonWriter.key("type").value(putIntegrationRequest.getType());
            }
            if (putIntegrationRequest.getIntegrationHttpMethod() != null) {
                jsonWriter.key("httpMethod").value(putIntegrationRequest.getIntegrationHttpMethod());
            }
            if (putIntegrationRequest.getUri() != null) {
                jsonWriter.key("uri").value(putIntegrationRequest.getUri());
            }
            if (putIntegrationRequest.getCredentials() != null) {
                jsonWriter.key("credentials").value(putIntegrationRequest.getCredentials());
            }
            if ((requestParametersMap = putIntegrationRequest.getRequestParameters()) != null) {
                jsonWriter.key("requestParameters");
                jsonWriter.object();
                for (Map.Entry<String, String> requestParametersMapValue : requestParametersMap.entrySet()) {
                    if (requestParametersMapValue.getValue() == null) continue;
                    jsonWriter.key(requestParametersMapValue.getKey());
                    jsonWriter.value(requestParametersMapValue.getValue());
                }
                jsonWriter.endObject();
            }
            if ((requestTemplatesMap = putIntegrationRequest.getRequestTemplates()) != null) {
                jsonWriter.key("requestTemplates");
                jsonWriter.object();
                for (Map.Entry<String, String> requestTemplatesMapValue : requestTemplatesMap.entrySet()) {
                    if (requestTemplatesMapValue.getValue() == null) continue;
                    jsonWriter.key(requestTemplatesMapValue.getKey());
                    jsonWriter.value(requestTemplatesMapValue.getValue());
                }
                jsonWriter.endObject();
            }
            if (putIntegrationRequest.getCacheNamespace() != null) {
                jsonWriter.key("cacheNamespace").value(putIntegrationRequest.getCacheNamespace());
            }
            if ((cacheKeyParametersList = putIntegrationRequest.getCacheKeyParameters()) != null) {
                jsonWriter.key("cacheKeyParameters");
                jsonWriter.array();
                for (String cacheKeyParametersListValue : cacheKeyParametersList) {
                    if (cacheKeyParametersListValue == null) continue;
                    jsonWriter.value(cacheKeyParametersListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

