/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.waf;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.PredefinedClientConfigurations;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.JsonErrorResponseHandlerV2;
import com.amazonaws.http.JsonResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.waf.AWSWAF;
import com.amazonaws.services.waf.model.CreateByteMatchSetRequest;
import com.amazonaws.services.waf.model.CreateByteMatchSetResult;
import com.amazonaws.services.waf.model.CreateIPSetRequest;
import com.amazonaws.services.waf.model.CreateIPSetResult;
import com.amazonaws.services.waf.model.CreateRuleRequest;
import com.amazonaws.services.waf.model.CreateRuleResult;
import com.amazonaws.services.waf.model.CreateSizeConstraintSetRequest;
import com.amazonaws.services.waf.model.CreateSizeConstraintSetResult;
import com.amazonaws.services.waf.model.CreateSqlInjectionMatchSetRequest;
import com.amazonaws.services.waf.model.CreateSqlInjectionMatchSetResult;
import com.amazonaws.services.waf.model.CreateWebACLRequest;
import com.amazonaws.services.waf.model.CreateWebACLResult;
import com.amazonaws.services.waf.model.DeleteByteMatchSetRequest;
import com.amazonaws.services.waf.model.DeleteByteMatchSetResult;
import com.amazonaws.services.waf.model.DeleteIPSetRequest;
import com.amazonaws.services.waf.model.DeleteIPSetResult;
import com.amazonaws.services.waf.model.DeleteRuleRequest;
import com.amazonaws.services.waf.model.DeleteRuleResult;
import com.amazonaws.services.waf.model.DeleteSizeConstraintSetRequest;
import com.amazonaws.services.waf.model.DeleteSizeConstraintSetResult;
import com.amazonaws.services.waf.model.DeleteSqlInjectionMatchSetRequest;
import com.amazonaws.services.waf.model.DeleteSqlInjectionMatchSetResult;
import com.amazonaws.services.waf.model.DeleteWebACLRequest;
import com.amazonaws.services.waf.model.DeleteWebACLResult;
import com.amazonaws.services.waf.model.GetByteMatchSetRequest;
import com.amazonaws.services.waf.model.GetByteMatchSetResult;
import com.amazonaws.services.waf.model.GetChangeTokenRequest;
import com.amazonaws.services.waf.model.GetChangeTokenResult;
import com.amazonaws.services.waf.model.GetChangeTokenStatusRequest;
import com.amazonaws.services.waf.model.GetChangeTokenStatusResult;
import com.amazonaws.services.waf.model.GetIPSetRequest;
import com.amazonaws.services.waf.model.GetIPSetResult;
import com.amazonaws.services.waf.model.GetRuleRequest;
import com.amazonaws.services.waf.model.GetRuleResult;
import com.amazonaws.services.waf.model.GetSampledRequestsRequest;
import com.amazonaws.services.waf.model.GetSampledRequestsResult;
import com.amazonaws.services.waf.model.GetSizeConstraintSetRequest;
import com.amazonaws.services.waf.model.GetSizeConstraintSetResult;
import com.amazonaws.services.waf.model.GetSqlInjectionMatchSetRequest;
import com.amazonaws.services.waf.model.GetSqlInjectionMatchSetResult;
import com.amazonaws.services.waf.model.GetWebACLRequest;
import com.amazonaws.services.waf.model.GetWebACLResult;
import com.amazonaws.services.waf.model.ListByteMatchSetsRequest;
import com.amazonaws.services.waf.model.ListByteMatchSetsResult;
import com.amazonaws.services.waf.model.ListIPSetsRequest;
import com.amazonaws.services.waf.model.ListIPSetsResult;
import com.amazonaws.services.waf.model.ListRulesRequest;
import com.amazonaws.services.waf.model.ListRulesResult;
import com.amazonaws.services.waf.model.ListSizeConstraintSetsRequest;
import com.amazonaws.services.waf.model.ListSizeConstraintSetsResult;
import com.amazonaws.services.waf.model.ListSqlInjectionMatchSetsRequest;
import com.amazonaws.services.waf.model.ListSqlInjectionMatchSetsResult;
import com.amazonaws.services.waf.model.ListWebACLsRequest;
import com.amazonaws.services.waf.model.ListWebACLsResult;
import com.amazonaws.services.waf.model.UpdateByteMatchSetRequest;
import com.amazonaws.services.waf.model.UpdateByteMatchSetResult;
import com.amazonaws.services.waf.model.UpdateIPSetRequest;
import com.amazonaws.services.waf.model.UpdateIPSetResult;
import com.amazonaws.services.waf.model.UpdateRuleRequest;
import com.amazonaws.services.waf.model.UpdateRuleResult;
import com.amazonaws.services.waf.model.UpdateSizeConstraintSetRequest;
import com.amazonaws.services.waf.model.UpdateSizeConstraintSetResult;
import com.amazonaws.services.waf.model.UpdateSqlInjectionMatchSetRequest;
import com.amazonaws.services.waf.model.UpdateSqlInjectionMatchSetResult;
import com.amazonaws.services.waf.model.UpdateWebACLRequest;
import com.amazonaws.services.waf.model.UpdateWebACLResult;
import com.amazonaws.services.waf.model.WAFDisallowedNameException;
import com.amazonaws.services.waf.model.WAFInternalErrorException;
import com.amazonaws.services.waf.model.WAFInvalidAccountException;
import com.amazonaws.services.waf.model.WAFInvalidOperationException;
import com.amazonaws.services.waf.model.WAFInvalidParameterException;
import com.amazonaws.services.waf.model.WAFLimitsExceededException;
import com.amazonaws.services.waf.model.WAFNonEmptyEntityException;
import com.amazonaws.services.waf.model.WAFNonexistentContainerException;
import com.amazonaws.services.waf.model.WAFNonexistentItemException;
import com.amazonaws.services.waf.model.WAFReferencedItemException;
import com.amazonaws.services.waf.model.WAFStaleDataException;
import com.amazonaws.services.waf.model.transform.CreateByteMatchSetRequestMarshaller;
import com.amazonaws.services.waf.model.transform.CreateByteMatchSetResultJsonUnmarshaller;
import com.amazonaws.services.waf.model.transform.CreateIPSetRequestMarshaller;
import com.amazonaws.services.waf.model.transform.CreateIPSetResultJsonUnmarshaller;
import com.amazonaws.services.waf.model.transform.CreateRuleRequestMarshaller;
import com.amazonaws.services.waf.model.transform.CreateRuleResultJsonUnmarshaller;
import com.amazonaws.services.waf.model.transform.CreateSizeConstraintSetRequestMarshaller;
import com.amazonaws.services.waf.model.transform.CreateSizeConstraintSetResultJsonUnmarshaller;
import com.amazonaws.services.waf.model.transform.CreateSqlInjectionMatchSetRequestMarshaller;
import com.amazonaws.services.waf.model.transform.CreateSqlInjectionMatchSetResultJsonUnmarshaller;
import com.amazonaws.services.waf.model.transform.CreateWebACLRequestMarshaller;
import com.amazonaws.services.waf.model.transform.CreateWebACLResultJsonUnmarshaller;
import com.amazonaws.services.waf.model.transform.DeleteByteMatchSetRequestMarshaller;
import com.amazonaws.services.waf.model.transform.DeleteByteMatchSetResultJsonUnmarshaller;
import com.amazonaws.services.waf.model.transform.DeleteIPSetRequestMarshaller;
import com.amazonaws.services.waf.model.transform.DeleteIPSetResultJsonUnmarshaller;
import com.amazonaws.services.waf.model.transform.DeleteRuleRequestMarshaller;
import com.amazonaws.services.waf.model.transform.DeleteRuleResultJsonUnmarshaller;
import com.amazonaws.services.waf.model.transform.DeleteSizeConstraintSetRequestMarshaller;
import com.amazonaws.services.waf.model.transform.DeleteSizeConstraintSetResultJsonUnmarshaller;
import com.amazonaws.services.waf.model.transform.DeleteSqlInjectionMatchSetRequestMarshaller;
import com.amazonaws.services.waf.model.transform.DeleteSqlInjectionMatchSetResultJsonUnmarshaller;
import com.amazonaws.services.waf.model.transform.DeleteWebACLRequestMarshaller;
import com.amazonaws.services.waf.model.transform.DeleteWebACLResultJsonUnmarshaller;
import com.amazonaws.services.waf.model.transform.GetByteMatchSetRequestMarshaller;
import com.amazonaws.services.waf.model.transform.GetByteMatchSetResultJsonUnmarshaller;
import com.amazonaws.services.waf.model.transform.GetChangeTokenRequestMarshaller;
import com.amazonaws.services.waf.model.transform.GetChangeTokenResultJsonUnmarshaller;
import com.amazonaws.services.waf.model.transform.GetChangeTokenStatusRequestMarshaller;
import com.amazonaws.services.waf.model.transform.GetChangeTokenStatusResultJsonUnmarshaller;
import com.amazonaws.services.waf.model.transform.GetIPSetRequestMarshaller;
import com.amazonaws.services.waf.model.transform.GetIPSetResultJsonUnmarshaller;
import com.amazonaws.services.waf.model.transform.GetRuleRequestMarshaller;
import com.amazonaws.services.waf.model.transform.GetRuleResultJsonUnmarshaller;
import com.amazonaws.services.waf.model.transform.GetSampledRequestsRequestMarshaller;
import com.amazonaws.services.waf.model.transform.GetSampledRequestsResultJsonUnmarshaller;
import com.amazonaws.services.waf.model.transform.GetSizeConstraintSetRequestMarshaller;
import com.amazonaws.services.waf.model.transform.GetSizeConstraintSetResultJsonUnmarshaller;
import com.amazonaws.services.waf.model.transform.GetSqlInjectionMatchSetRequestMarshaller;
import com.amazonaws.services.waf.model.transform.GetSqlInjectionMatchSetResultJsonUnmarshaller;
import com.amazonaws.services.waf.model.transform.GetWebACLRequestMarshaller;
import com.amazonaws.services.waf.model.transform.GetWebACLResultJsonUnmarshaller;
import com.amazonaws.services.waf.model.transform.ListByteMatchSetsRequestMarshaller;
import com.amazonaws.services.waf.model.transform.ListByteMatchSetsResultJsonUnmarshaller;
import com.amazonaws.services.waf.model.transform.ListIPSetsRequestMarshaller;
import com.amazonaws.services.waf.model.transform.ListIPSetsResultJsonUnmarshaller;
import com.amazonaws.services.waf.model.transform.ListRulesRequestMarshaller;
import com.amazonaws.services.waf.model.transform.ListRulesResultJsonUnmarshaller;
import com.amazonaws.services.waf.model.transform.ListSizeConstraintSetsRequestMarshaller;
import com.amazonaws.services.waf.model.transform.ListSizeConstraintSetsResultJsonUnmarshaller;
import com.amazonaws.services.waf.model.transform.ListSqlInjectionMatchSetsRequestMarshaller;
import com.amazonaws.services.waf.model.transform.ListSqlInjectionMatchSetsResultJsonUnmarshaller;
import com.amazonaws.services.waf.model.transform.ListWebACLsRequestMarshaller;
import com.amazonaws.services.waf.model.transform.ListWebACLsResultJsonUnmarshaller;
import com.amazonaws.services.waf.model.transform.UpdateByteMatchSetRequestMarshaller;
import com.amazonaws.services.waf.model.transform.UpdateByteMatchSetResultJsonUnmarshaller;
import com.amazonaws.services.waf.model.transform.UpdateIPSetRequestMarshaller;
import com.amazonaws.services.waf.model.transform.UpdateIPSetResultJsonUnmarshaller;
import com.amazonaws.services.waf.model.transform.UpdateRuleRequestMarshaller;
import com.amazonaws.services.waf.model.transform.UpdateRuleResultJsonUnmarshaller;
import com.amazonaws.services.waf.model.transform.UpdateSizeConstraintSetRequestMarshaller;
import com.amazonaws.services.waf.model.transform.UpdateSizeConstraintSetResultJsonUnmarshaller;
import com.amazonaws.services.waf.model.transform.UpdateSqlInjectionMatchSetRequestMarshaller;
import com.amazonaws.services.waf.model.transform.UpdateSqlInjectionMatchSetResultJsonUnmarshaller;
import com.amazonaws.services.waf.model.transform.UpdateWebACLRequestMarshaller;
import com.amazonaws.services.waf.model.transform.UpdateWebACLResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshallerV2;
import com.amazonaws.util.AWSRequestMetrics;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSWAFClient
extends AmazonWebServiceClient
implements AWSWAF {
    private AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSWAF.class);
    private static final String DEFAULT_SIGNING_NAME = "waf";
    private static final String DEFAULT_ENDPOINT_PREFIX = "waf";
    protected List<JsonErrorUnmarshallerV2> jsonErrorUnmarshallers = new ArrayList<JsonErrorUnmarshallerV2>();

    public AWSWAFClient() {
        this(new DefaultAWSCredentialsProviderChain(), PredefinedClientConfigurations.defaultConfig());
    }

    public AWSWAFClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AWSWAFClient(AWSCredentials awsCredentials) {
        this(awsCredentials, PredefinedClientConfigurations.defaultConfig());
    }

    public AWSWAFClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AWSWAFClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, PredefinedClientConfigurations.defaultConfig());
    }

    public AWSWAFClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    public AWSWAFClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(WAFInternalErrorException.class, "WAFInternalErrorException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(WAFReferencedItemException.class, "WAFReferencedItemException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(WAFInvalidAccountException.class, "WAFInvalidAccountException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(WAFStaleDataException.class, "WAFStaleDataException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(WAFNonexistentContainerException.class, "WAFNonexistentContainerException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(WAFLimitsExceededException.class, "WAFLimitsExceededException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(WAFInvalidParameterException.class, "WAFInvalidParameterException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(WAFNonEmptyEntityException.class, "WAFNonEmptyEntityException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(WAFDisallowedNameException.class, "WAFDisallowedNameException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(WAFInvalidOperationException.class, "WAFInvalidOperationException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(WAFNonexistentItemException.class, "WAFNonexistentItemException"));
        this.jsonErrorUnmarshallers.add(JsonErrorUnmarshallerV2.DEFAULT_UNMARSHALLER);
        this.setServiceNameIntern("waf");
        this.setEndpointPrefix("waf");
        this.setEndpoint("https://waf.amazonaws.com/");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/waf/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/waf/request.handler2s"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateByteMatchSetResult createByteMatchSet(CreateByteMatchSetRequest createByteMatchSetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createByteMatchSetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateByteMatchSetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateByteMatchSetRequestMarshaller().marshall(super.beforeMarshalling(createByteMatchSetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<CreateByteMatchSetResult> responseHandler = new JsonResponseHandler<CreateByteMatchSetResult>(new CreateByteMatchSetResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            CreateByteMatchSetResult createByteMatchSetResult = (CreateByteMatchSetResult)response.getAwsResponse();
            return createByteMatchSetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateIPSetResult createIPSet(CreateIPSetRequest createIPSetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createIPSetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateIPSetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateIPSetRequestMarshaller().marshall(super.beforeMarshalling(createIPSetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<CreateIPSetResult> responseHandler = new JsonResponseHandler<CreateIPSetResult>(new CreateIPSetResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            CreateIPSetResult createIPSetResult = (CreateIPSetResult)response.getAwsResponse();
            return createIPSetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateRuleResult createRule(CreateRuleRequest createRuleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createRuleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateRuleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateRuleRequestMarshaller().marshall(super.beforeMarshalling(createRuleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<CreateRuleResult> responseHandler = new JsonResponseHandler<CreateRuleResult>(new CreateRuleResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            CreateRuleResult createRuleResult = (CreateRuleResult)response.getAwsResponse();
            return createRuleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateSizeConstraintSetResult createSizeConstraintSet(CreateSizeConstraintSetRequest createSizeConstraintSetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createSizeConstraintSetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateSizeConstraintSetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateSizeConstraintSetRequestMarshaller().marshall(super.beforeMarshalling(createSizeConstraintSetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<CreateSizeConstraintSetResult> responseHandler = new JsonResponseHandler<CreateSizeConstraintSetResult>(new CreateSizeConstraintSetResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            CreateSizeConstraintSetResult createSizeConstraintSetResult = (CreateSizeConstraintSetResult)response.getAwsResponse();
            return createSizeConstraintSetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateSqlInjectionMatchSetResult createSqlInjectionMatchSet(CreateSqlInjectionMatchSetRequest createSqlInjectionMatchSetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createSqlInjectionMatchSetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateSqlInjectionMatchSetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateSqlInjectionMatchSetRequestMarshaller().marshall(super.beforeMarshalling(createSqlInjectionMatchSetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<CreateSqlInjectionMatchSetResult> responseHandler = new JsonResponseHandler<CreateSqlInjectionMatchSetResult>(new CreateSqlInjectionMatchSetResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            CreateSqlInjectionMatchSetResult createSqlInjectionMatchSetResult = (CreateSqlInjectionMatchSetResult)response.getAwsResponse();
            return createSqlInjectionMatchSetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateWebACLResult createWebACL(CreateWebACLRequest createWebACLRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createWebACLRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateWebACLRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateWebACLRequestMarshaller().marshall(super.beforeMarshalling(createWebACLRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<CreateWebACLResult> responseHandler = new JsonResponseHandler<CreateWebACLResult>(new CreateWebACLResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            CreateWebACLResult createWebACLResult = (CreateWebACLResult)response.getAwsResponse();
            return createWebACLResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteByteMatchSetResult deleteByteMatchSet(DeleteByteMatchSetRequest deleteByteMatchSetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteByteMatchSetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteByteMatchSetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteByteMatchSetRequestMarshaller().marshall(super.beforeMarshalling(deleteByteMatchSetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<DeleteByteMatchSetResult> responseHandler = new JsonResponseHandler<DeleteByteMatchSetResult>(new DeleteByteMatchSetResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            DeleteByteMatchSetResult deleteByteMatchSetResult = (DeleteByteMatchSetResult)response.getAwsResponse();
            return deleteByteMatchSetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteIPSetResult deleteIPSet(DeleteIPSetRequest deleteIPSetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteIPSetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteIPSetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteIPSetRequestMarshaller().marshall(super.beforeMarshalling(deleteIPSetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<DeleteIPSetResult> responseHandler = new JsonResponseHandler<DeleteIPSetResult>(new DeleteIPSetResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            DeleteIPSetResult deleteIPSetResult = (DeleteIPSetResult)response.getAwsResponse();
            return deleteIPSetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteRuleResult deleteRule(DeleteRuleRequest deleteRuleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteRuleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteRuleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteRuleRequestMarshaller().marshall(super.beforeMarshalling(deleteRuleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<DeleteRuleResult> responseHandler = new JsonResponseHandler<DeleteRuleResult>(new DeleteRuleResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            DeleteRuleResult deleteRuleResult = (DeleteRuleResult)response.getAwsResponse();
            return deleteRuleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteSizeConstraintSetResult deleteSizeConstraintSet(DeleteSizeConstraintSetRequest deleteSizeConstraintSetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteSizeConstraintSetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteSizeConstraintSetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteSizeConstraintSetRequestMarshaller().marshall(super.beforeMarshalling(deleteSizeConstraintSetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<DeleteSizeConstraintSetResult> responseHandler = new JsonResponseHandler<DeleteSizeConstraintSetResult>(new DeleteSizeConstraintSetResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            DeleteSizeConstraintSetResult deleteSizeConstraintSetResult = (DeleteSizeConstraintSetResult)response.getAwsResponse();
            return deleteSizeConstraintSetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteSqlInjectionMatchSetResult deleteSqlInjectionMatchSet(DeleteSqlInjectionMatchSetRequest deleteSqlInjectionMatchSetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteSqlInjectionMatchSetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteSqlInjectionMatchSetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteSqlInjectionMatchSetRequestMarshaller().marshall(super.beforeMarshalling(deleteSqlInjectionMatchSetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<DeleteSqlInjectionMatchSetResult> responseHandler = new JsonResponseHandler<DeleteSqlInjectionMatchSetResult>(new DeleteSqlInjectionMatchSetResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            DeleteSqlInjectionMatchSetResult deleteSqlInjectionMatchSetResult = (DeleteSqlInjectionMatchSetResult)response.getAwsResponse();
            return deleteSqlInjectionMatchSetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteWebACLResult deleteWebACL(DeleteWebACLRequest deleteWebACLRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteWebACLRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteWebACLRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteWebACLRequestMarshaller().marshall(super.beforeMarshalling(deleteWebACLRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<DeleteWebACLResult> responseHandler = new JsonResponseHandler<DeleteWebACLResult>(new DeleteWebACLResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            DeleteWebACLResult deleteWebACLResult = (DeleteWebACLResult)response.getAwsResponse();
            return deleteWebACLResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetByteMatchSetResult getByteMatchSet(GetByteMatchSetRequest getByteMatchSetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getByteMatchSetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetByteMatchSetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetByteMatchSetRequestMarshaller().marshall(super.beforeMarshalling(getByteMatchSetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<GetByteMatchSetResult> responseHandler = new JsonResponseHandler<GetByteMatchSetResult>(new GetByteMatchSetResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            GetByteMatchSetResult getByteMatchSetResult = (GetByteMatchSetResult)response.getAwsResponse();
            return getByteMatchSetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetChangeTokenResult getChangeToken(GetChangeTokenRequest getChangeTokenRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getChangeTokenRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetChangeTokenRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetChangeTokenRequestMarshaller().marshall(super.beforeMarshalling(getChangeTokenRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<GetChangeTokenResult> responseHandler = new JsonResponseHandler<GetChangeTokenResult>(new GetChangeTokenResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            GetChangeTokenResult getChangeTokenResult = (GetChangeTokenResult)response.getAwsResponse();
            return getChangeTokenResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetChangeTokenStatusResult getChangeTokenStatus(GetChangeTokenStatusRequest getChangeTokenStatusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getChangeTokenStatusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetChangeTokenStatusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetChangeTokenStatusRequestMarshaller().marshall(super.beforeMarshalling(getChangeTokenStatusRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<GetChangeTokenStatusResult> responseHandler = new JsonResponseHandler<GetChangeTokenStatusResult>(new GetChangeTokenStatusResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            GetChangeTokenStatusResult getChangeTokenStatusResult = (GetChangeTokenStatusResult)response.getAwsResponse();
            return getChangeTokenStatusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetIPSetResult getIPSet(GetIPSetRequest getIPSetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getIPSetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetIPSetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetIPSetRequestMarshaller().marshall(super.beforeMarshalling(getIPSetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<GetIPSetResult> responseHandler = new JsonResponseHandler<GetIPSetResult>(new GetIPSetResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            GetIPSetResult getIPSetResult = (GetIPSetResult)response.getAwsResponse();
            return getIPSetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetRuleResult getRule(GetRuleRequest getRuleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getRuleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetRuleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetRuleRequestMarshaller().marshall(super.beforeMarshalling(getRuleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<GetRuleResult> responseHandler = new JsonResponseHandler<GetRuleResult>(new GetRuleResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            GetRuleResult getRuleResult = (GetRuleResult)response.getAwsResponse();
            return getRuleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSampledRequestsResult getSampledRequests(GetSampledRequestsRequest getSampledRequestsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getSampledRequestsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetSampledRequestsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetSampledRequestsRequestMarshaller().marshall(super.beforeMarshalling(getSampledRequestsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<GetSampledRequestsResult> responseHandler = new JsonResponseHandler<GetSampledRequestsResult>(new GetSampledRequestsResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            GetSampledRequestsResult getSampledRequestsResult = (GetSampledRequestsResult)response.getAwsResponse();
            return getSampledRequestsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSizeConstraintSetResult getSizeConstraintSet(GetSizeConstraintSetRequest getSizeConstraintSetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getSizeConstraintSetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetSizeConstraintSetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetSizeConstraintSetRequestMarshaller().marshall(super.beforeMarshalling(getSizeConstraintSetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<GetSizeConstraintSetResult> responseHandler = new JsonResponseHandler<GetSizeConstraintSetResult>(new GetSizeConstraintSetResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            GetSizeConstraintSetResult getSizeConstraintSetResult = (GetSizeConstraintSetResult)response.getAwsResponse();
            return getSizeConstraintSetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSqlInjectionMatchSetResult getSqlInjectionMatchSet(GetSqlInjectionMatchSetRequest getSqlInjectionMatchSetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getSqlInjectionMatchSetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetSqlInjectionMatchSetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetSqlInjectionMatchSetRequestMarshaller().marshall(super.beforeMarshalling(getSqlInjectionMatchSetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<GetSqlInjectionMatchSetResult> responseHandler = new JsonResponseHandler<GetSqlInjectionMatchSetResult>(new GetSqlInjectionMatchSetResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            GetSqlInjectionMatchSetResult getSqlInjectionMatchSetResult = (GetSqlInjectionMatchSetResult)response.getAwsResponse();
            return getSqlInjectionMatchSetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetWebACLResult getWebACL(GetWebACLRequest getWebACLRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getWebACLRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetWebACLRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetWebACLRequestMarshaller().marshall(super.beforeMarshalling(getWebACLRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<GetWebACLResult> responseHandler = new JsonResponseHandler<GetWebACLResult>(new GetWebACLResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            GetWebACLResult getWebACLResult = (GetWebACLResult)response.getAwsResponse();
            return getWebACLResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListByteMatchSetsResult listByteMatchSets(ListByteMatchSetsRequest listByteMatchSetsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listByteMatchSetsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListByteMatchSetsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListByteMatchSetsRequestMarshaller().marshall(super.beforeMarshalling(listByteMatchSetsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<ListByteMatchSetsResult> responseHandler = new JsonResponseHandler<ListByteMatchSetsResult>(new ListByteMatchSetsResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            ListByteMatchSetsResult listByteMatchSetsResult = (ListByteMatchSetsResult)response.getAwsResponse();
            return listByteMatchSetsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListIPSetsResult listIPSets(ListIPSetsRequest listIPSetsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listIPSetsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListIPSetsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListIPSetsRequestMarshaller().marshall(super.beforeMarshalling(listIPSetsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<ListIPSetsResult> responseHandler = new JsonResponseHandler<ListIPSetsResult>(new ListIPSetsResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            ListIPSetsResult listIPSetsResult = (ListIPSetsResult)response.getAwsResponse();
            return listIPSetsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRulesResult listRules(ListRulesRequest listRulesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listRulesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListRulesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListRulesRequestMarshaller().marshall(super.beforeMarshalling(listRulesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<ListRulesResult> responseHandler = new JsonResponseHandler<ListRulesResult>(new ListRulesResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            ListRulesResult listRulesResult = (ListRulesResult)response.getAwsResponse();
            return listRulesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSizeConstraintSetsResult listSizeConstraintSets(ListSizeConstraintSetsRequest listSizeConstraintSetsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listSizeConstraintSetsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListSizeConstraintSetsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListSizeConstraintSetsRequestMarshaller().marshall(super.beforeMarshalling(listSizeConstraintSetsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<ListSizeConstraintSetsResult> responseHandler = new JsonResponseHandler<ListSizeConstraintSetsResult>(new ListSizeConstraintSetsResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            ListSizeConstraintSetsResult listSizeConstraintSetsResult = (ListSizeConstraintSetsResult)response.getAwsResponse();
            return listSizeConstraintSetsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSqlInjectionMatchSetsResult listSqlInjectionMatchSets(ListSqlInjectionMatchSetsRequest listSqlInjectionMatchSetsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listSqlInjectionMatchSetsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListSqlInjectionMatchSetsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListSqlInjectionMatchSetsRequestMarshaller().marshall(super.beforeMarshalling(listSqlInjectionMatchSetsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<ListSqlInjectionMatchSetsResult> responseHandler = new JsonResponseHandler<ListSqlInjectionMatchSetsResult>(new ListSqlInjectionMatchSetsResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            ListSqlInjectionMatchSetsResult listSqlInjectionMatchSetsResult = (ListSqlInjectionMatchSetsResult)response.getAwsResponse();
            return listSqlInjectionMatchSetsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListWebACLsResult listWebACLs(ListWebACLsRequest listWebACLsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listWebACLsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListWebACLsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListWebACLsRequestMarshaller().marshall(super.beforeMarshalling(listWebACLsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<ListWebACLsResult> responseHandler = new JsonResponseHandler<ListWebACLsResult>(new ListWebACLsResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            ListWebACLsResult listWebACLsResult = (ListWebACLsResult)response.getAwsResponse();
            return listWebACLsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateByteMatchSetResult updateByteMatchSet(UpdateByteMatchSetRequest updateByteMatchSetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateByteMatchSetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateByteMatchSetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateByteMatchSetRequestMarshaller().marshall(super.beforeMarshalling(updateByteMatchSetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<UpdateByteMatchSetResult> responseHandler = new JsonResponseHandler<UpdateByteMatchSetResult>(new UpdateByteMatchSetResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            UpdateByteMatchSetResult updateByteMatchSetResult = (UpdateByteMatchSetResult)response.getAwsResponse();
            return updateByteMatchSetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateIPSetResult updateIPSet(UpdateIPSetRequest updateIPSetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateIPSetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateIPSetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateIPSetRequestMarshaller().marshall(super.beforeMarshalling(updateIPSetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<UpdateIPSetResult> responseHandler = new JsonResponseHandler<UpdateIPSetResult>(new UpdateIPSetResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            UpdateIPSetResult updateIPSetResult = (UpdateIPSetResult)response.getAwsResponse();
            return updateIPSetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateRuleResult updateRule(UpdateRuleRequest updateRuleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateRuleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateRuleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateRuleRequestMarshaller().marshall(super.beforeMarshalling(updateRuleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<UpdateRuleResult> responseHandler = new JsonResponseHandler<UpdateRuleResult>(new UpdateRuleResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            UpdateRuleResult updateRuleResult = (UpdateRuleResult)response.getAwsResponse();
            return updateRuleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateSizeConstraintSetResult updateSizeConstraintSet(UpdateSizeConstraintSetRequest updateSizeConstraintSetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateSizeConstraintSetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateSizeConstraintSetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateSizeConstraintSetRequestMarshaller().marshall(super.beforeMarshalling(updateSizeConstraintSetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<UpdateSizeConstraintSetResult> responseHandler = new JsonResponseHandler<UpdateSizeConstraintSetResult>(new UpdateSizeConstraintSetResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            UpdateSizeConstraintSetResult updateSizeConstraintSetResult = (UpdateSizeConstraintSetResult)response.getAwsResponse();
            return updateSizeConstraintSetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateSqlInjectionMatchSetResult updateSqlInjectionMatchSet(UpdateSqlInjectionMatchSetRequest updateSqlInjectionMatchSetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateSqlInjectionMatchSetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateSqlInjectionMatchSetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateSqlInjectionMatchSetRequestMarshaller().marshall(super.beforeMarshalling(updateSqlInjectionMatchSetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<UpdateSqlInjectionMatchSetResult> responseHandler = new JsonResponseHandler<UpdateSqlInjectionMatchSetResult>(new UpdateSqlInjectionMatchSetResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            UpdateSqlInjectionMatchSetResult updateSqlInjectionMatchSetResult = (UpdateSqlInjectionMatchSetResult)response.getAwsResponse();
            return updateSqlInjectionMatchSetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateWebACLResult updateWebACL(UpdateWebACLRequest updateWebACLRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateWebACLRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateWebACLRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateWebACLRequestMarshaller().marshall(super.beforeMarshalling(updateWebACLRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<UpdateWebACLResult> responseHandler = new JsonResponseHandler<UpdateWebACLResult>(new UpdateWebACLResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            UpdateWebACLResult updateWebACLResult = (UpdateWebACLResult)response.getAwsResponse();
            return updateWebACLResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        AWSCredentials credentials;
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.CredentialsRequestTime);
        try {
            credentials = this.awsCredentialsProvider.getCredentials();
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.CredentialsRequestTime);
        }
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setCredentials(credentials);
        JsonErrorResponseHandlerV2 errorResponseHandler = new JsonErrorResponseHandlerV2(this.jsonErrorUnmarshallers);
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

