/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.opsworks.model.BlockDeviceMapping;
import com.amazonaws.services.opsworks.model.transform.EbsBlockDeviceJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class BlockDeviceMappingJsonMarshaller {
    private static BlockDeviceMappingJsonMarshaller instance;

    public void marshall(BlockDeviceMapping blockDeviceMapping, JSONWriter jsonWriter) {
        if (blockDeviceMapping == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (blockDeviceMapping.getDeviceName() != null) {
                jsonWriter.key("DeviceName").value(blockDeviceMapping.getDeviceName());
            }
            if (blockDeviceMapping.getNoDevice() != null) {
                jsonWriter.key("NoDevice").value(blockDeviceMapping.getNoDevice());
            }
            if (blockDeviceMapping.getVirtualName() != null) {
                jsonWriter.key("VirtualName").value(blockDeviceMapping.getVirtualName());
            }
            if (blockDeviceMapping.getEbs() != null) {
                jsonWriter.key("Ebs");
                EbsBlockDeviceJsonMarshaller.getInstance().marshall(blockDeviceMapping.getEbs(), jsonWriter);
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static BlockDeviceMappingJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new BlockDeviceMappingJsonMarshaller();
        }
        return instance;
    }
}

