/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.iot.model.AttributePayload;
import com.amazonaws.util.json.JSONWriter;
import java.util.Map;

public class AttributePayloadJsonMarshaller {
    private static AttributePayloadJsonMarshaller instance;

    public void marshall(AttributePayload attributePayload, JSONWriter jsonWriter) {
        if (attributePayload == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            Map<String, String> attributesMap = attributePayload.getAttributes();
            if (attributesMap != null) {
                jsonWriter.key("attributes");
                jsonWriter.object();
                for (Map.Entry<String, String> attributesMapValue : attributesMap.entrySet()) {
                    if (attributesMapValue.getValue() == null) continue;
                    jsonWriter.key(attributesMapValue.getKey());
                    jsonWriter.value(attributesMapValue.getValue());
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static AttributePayloadJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new AttributePayloadJsonMarshaller();
        }
        return instance;
    }
}

