/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecr.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ecr.model.BatchCheckLayerAvailabilityRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.List;

public class BatchCheckLayerAvailabilityRequestMarshaller
implements Marshaller<Request<BatchCheckLayerAvailabilityRequest>, BatchCheckLayerAvailabilityRequest> {
    @Override
    public Request<BatchCheckLayerAvailabilityRequest> marshall(BatchCheckLayerAvailabilityRequest batchCheckLayerAvailabilityRequest) {
        if (batchCheckLayerAvailabilityRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<BatchCheckLayerAvailabilityRequest> request = new DefaultRequest<BatchCheckLayerAvailabilityRequest>(batchCheckLayerAvailabilityRequest, "AmazonECR");
        request.addHeader("X-Amz-Target", "AmazonEC2ContainerRegistry_V20150921.BatchCheckLayerAvailability");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<String> layerDigestsList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (batchCheckLayerAvailabilityRequest.getRegistryId() != null) {
                jsonWriter.key("registryId").value(batchCheckLayerAvailabilityRequest.getRegistryId());
            }
            if (batchCheckLayerAvailabilityRequest.getRepositoryName() != null) {
                jsonWriter.key("repositoryName").value(batchCheckLayerAvailabilityRequest.getRepositoryName());
            }
            if ((layerDigestsList = batchCheckLayerAvailabilityRequest.getLayerDigests()) != null) {
                jsonWriter.key("layerDigests");
                jsonWriter.array();
                for (String layerDigestsListValue : layerDigestsList) {
                    if (layerDigestsListValue == null) continue;
                    jsonWriter.value(layerDigestsListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

