/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.certificatemanager.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.certificatemanager.model.DomainValidationOption;
import com.amazonaws.services.certificatemanager.model.RequestCertificateRequest;
import com.amazonaws.services.certificatemanager.model.transform.DomainValidationOptionJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.List;

public class RequestCertificateRequestMarshaller
implements Marshaller<Request<RequestCertificateRequest>, RequestCertificateRequest> {
    @Override
    public Request<RequestCertificateRequest> marshall(RequestCertificateRequest requestCertificateRequest) {
        if (requestCertificateRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<RequestCertificateRequest> request = new DefaultRequest<RequestCertificateRequest>(requestCertificateRequest, "AWSCertificateManager");
        request.addHeader("X-Amz-Target", "CertificateManager.RequestCertificate");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<DomainValidationOption> domainValidationOptionsList;
            List<String> subjectAlternativeNamesList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (requestCertificateRequest.getDomainName() != null) {
                jsonWriter.key("DomainName").value(requestCertificateRequest.getDomainName());
            }
            if ((subjectAlternativeNamesList = requestCertificateRequest.getSubjectAlternativeNames()) != null) {
                jsonWriter.key("SubjectAlternativeNames");
                jsonWriter.array();
                for (String subjectAlternativeNamesListValue : subjectAlternativeNamesList) {
                    if (subjectAlternativeNamesListValue == null) continue;
                    jsonWriter.value(subjectAlternativeNamesListValue);
                }
                jsonWriter.endArray();
            }
            if (requestCertificateRequest.getIdempotencyToken() != null) {
                jsonWriter.key("IdempotencyToken").value(requestCertificateRequest.getIdempotencyToken());
            }
            if ((domainValidationOptionsList = requestCertificateRequest.getDomainValidationOptions()) != null) {
                jsonWriter.key("DomainValidationOptions");
                jsonWriter.array();
                for (DomainValidationOption domainValidationOptionsListValue : domainValidationOptionsList) {
                    if (domainValidationOptionsListValue == null) continue;
                    DomainValidationOptionJsonMarshaller.getInstance().marshall(domainValidationOptionsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

