/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simplesystemsmanagement.model.Command;
import com.amazonaws.util.json.JSONWriter;
import java.util.List;
import java.util.Map;

public class CommandJsonMarshaller {
    private static CommandJsonMarshaller instance;

    public void marshall(Command command, JSONWriter jsonWriter) {
        if (command == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList instanceIdsList;
            Map<String, List<String>> parametersMap;
            jsonWriter.object();
            if (command.getCommandId() != null) {
                jsonWriter.key("CommandId").value(command.getCommandId());
            }
            if (command.getDocumentName() != null) {
                jsonWriter.key("DocumentName").value(command.getDocumentName());
            }
            if (command.getComment() != null) {
                jsonWriter.key("Comment").value(command.getComment());
            }
            if (command.getExpiresAfter() != null) {
                jsonWriter.key("ExpiresAfter").value(command.getExpiresAfter());
            }
            if ((parametersMap = command.getParameters()) != null) {
                jsonWriter.key("Parameters");
                jsonWriter.object();
                for (Map.Entry<String, List<String>> parametersMapValue : parametersMap.entrySet()) {
                    if (parametersMapValue.getValue() == null) continue;
                    jsonWriter.key(parametersMapValue.getKey());
                    jsonWriter.array();
                    for (String parametersMapValueList : parametersMapValue.getValue()) {
                        if (parametersMapValueList == null) continue;
                        jsonWriter.value(parametersMapValueList);
                    }
                    jsonWriter.endArray();
                }
                jsonWriter.endObject();
            }
            if (!(instanceIdsList = (SdkInternalList)command.getInstanceIds()).isEmpty() || !instanceIdsList.isAutoConstruct()) {
                jsonWriter.key("InstanceIds");
                jsonWriter.array();
                for (String instanceIdsListValue : instanceIdsList) {
                    if (instanceIdsListValue == null) continue;
                    jsonWriter.value(instanceIdsListValue);
                }
                jsonWriter.endArray();
            }
            if (command.getRequestedDateTime() != null) {
                jsonWriter.key("RequestedDateTime").value(command.getRequestedDateTime());
            }
            if (command.getStatus() != null) {
                jsonWriter.key("Status").value(command.getStatus());
            }
            if (command.getOutputS3BucketName() != null) {
                jsonWriter.key("OutputS3BucketName").value(command.getOutputS3BucketName());
            }
            if (command.getOutputS3KeyPrefix() != null) {
                jsonWriter.key("OutputS3KeyPrefix").value(command.getOutputS3KeyPrefix());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static CommandJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new CommandJsonMarshaller();
        }
        return instance;
    }
}

