/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.identitymanagement.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.identitymanagement.model.GetSSHPublicKeyRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class GetSSHPublicKeyRequestMarshaller
implements Marshaller<Request<GetSSHPublicKeyRequest>, GetSSHPublicKeyRequest> {
    @Override
    public Request<GetSSHPublicKeyRequest> marshall(GetSSHPublicKeyRequest getSSHPublicKeyRequest) {
        if (getSSHPublicKeyRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetSSHPublicKeyRequest> request = new DefaultRequest<GetSSHPublicKeyRequest>(getSSHPublicKeyRequest, "AmazonIdentityManagement");
        request.addParameter("Action", "GetSSHPublicKey");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (getSSHPublicKeyRequest.getUserName() != null) {
            request.addParameter("UserName", StringUtils.fromString(getSSHPublicKeyRequest.getUserName()));
        }
        if (getSSHPublicKeyRequest.getSSHPublicKeyId() != null) {
            request.addParameter("SSHPublicKeyId", StringUtils.fromString(getSSHPublicKeyRequest.getSSHPublicKeyId()));
        }
        if (getSSHPublicKeyRequest.getEncoding() != null) {
            request.addParameter("Encoding", StringUtils.fromString(getSSHPublicKeyRequest.getEncoding()));
        }
        return request;
    }
}

