/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.PredefinedClientConfigurations;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingAsync;
import com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient;
import com.amazonaws.services.elasticloadbalancing.model.AddTagsRequest;
import com.amazonaws.services.elasticloadbalancing.model.AddTagsResult;
import com.amazonaws.services.elasticloadbalancing.model.ApplySecurityGroupsToLoadBalancerRequest;
import com.amazonaws.services.elasticloadbalancing.model.ApplySecurityGroupsToLoadBalancerResult;
import com.amazonaws.services.elasticloadbalancing.model.AttachLoadBalancerToSubnetsRequest;
import com.amazonaws.services.elasticloadbalancing.model.AttachLoadBalancerToSubnetsResult;
import com.amazonaws.services.elasticloadbalancing.model.ConfigureHealthCheckRequest;
import com.amazonaws.services.elasticloadbalancing.model.ConfigureHealthCheckResult;
import com.amazonaws.services.elasticloadbalancing.model.CreateAppCookieStickinessPolicyRequest;
import com.amazonaws.services.elasticloadbalancing.model.CreateAppCookieStickinessPolicyResult;
import com.amazonaws.services.elasticloadbalancing.model.CreateLBCookieStickinessPolicyRequest;
import com.amazonaws.services.elasticloadbalancing.model.CreateLBCookieStickinessPolicyResult;
import com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerListenersRequest;
import com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerListenersResult;
import com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerPolicyRequest;
import com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerPolicyResult;
import com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerRequest;
import com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerResult;
import com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerListenersRequest;
import com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerListenersResult;
import com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerPolicyRequest;
import com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerPolicyResult;
import com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerRequest;
import com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerResult;
import com.amazonaws.services.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerRequest;
import com.amazonaws.services.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerResult;
import com.amazonaws.services.elasticloadbalancing.model.DescribeInstanceHealthRequest;
import com.amazonaws.services.elasticloadbalancing.model.DescribeInstanceHealthResult;
import com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerAttributesRequest;
import com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerAttributesResult;
import com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerPoliciesRequest;
import com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerPoliciesResult;
import com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerPolicyTypesRequest;
import com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerPolicyTypesResult;
import com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancersRequest;
import com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancersResult;
import com.amazonaws.services.elasticloadbalancing.model.DescribeTagsRequest;
import com.amazonaws.services.elasticloadbalancing.model.DescribeTagsResult;
import com.amazonaws.services.elasticloadbalancing.model.DetachLoadBalancerFromSubnetsRequest;
import com.amazonaws.services.elasticloadbalancing.model.DetachLoadBalancerFromSubnetsResult;
import com.amazonaws.services.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerRequest;
import com.amazonaws.services.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerResult;
import com.amazonaws.services.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerRequest;
import com.amazonaws.services.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerResult;
import com.amazonaws.services.elasticloadbalancing.model.ModifyLoadBalancerAttributesRequest;
import com.amazonaws.services.elasticloadbalancing.model.ModifyLoadBalancerAttributesResult;
import com.amazonaws.services.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerRequest;
import com.amazonaws.services.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerResult;
import com.amazonaws.services.elasticloadbalancing.model.RemoveTagsRequest;
import com.amazonaws.services.elasticloadbalancing.model.RemoveTagsResult;
import com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerListenerSSLCertificateRequest;
import com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerListenerSSLCertificateResult;
import com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerPoliciesForBackendServerRequest;
import com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerPoliciesForBackendServerResult;
import com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerPoliciesOfListenerRequest;
import com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerPoliciesOfListenerResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AmazonElasticLoadBalancingAsyncClient
extends AmazonElasticLoadBalancingClient
implements AmazonElasticLoadBalancingAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public AmazonElasticLoadBalancingAsyncClient() {
        this(new DefaultAWSCredentialsProviderChain());
    }

    public AmazonElasticLoadBalancingAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonElasticLoadBalancingAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AmazonElasticLoadBalancingAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, PredefinedClientConfigurations.defaultConfig(), executorService);
    }

    public AmazonElasticLoadBalancingAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonElasticLoadBalancingAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AmazonElasticLoadBalancingAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonElasticLoadBalancingAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, PredefinedClientConfigurations.defaultConfig(), executorService);
    }

    public AmazonElasticLoadBalancingAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AddTagsResult> addTagsAsync(AddTagsRequest request) {
        return this.addTagsAsync(request, null);
    }

    @Override
    public Future<AddTagsResult> addTagsAsync(final AddTagsRequest request, final AsyncHandler<AddTagsRequest, AddTagsResult> asyncHandler) {
        return this.executorService.submit(new Callable<AddTagsResult>(){

            @Override
            public AddTagsResult call() throws Exception {
                AddTagsResult result;
                try {
                    result = AmazonElasticLoadBalancingAsyncClient.this.addTags(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ApplySecurityGroupsToLoadBalancerResult> applySecurityGroupsToLoadBalancerAsync(ApplySecurityGroupsToLoadBalancerRequest request) {
        return this.applySecurityGroupsToLoadBalancerAsync(request, null);
    }

    @Override
    public Future<ApplySecurityGroupsToLoadBalancerResult> applySecurityGroupsToLoadBalancerAsync(final ApplySecurityGroupsToLoadBalancerRequest request, final AsyncHandler<ApplySecurityGroupsToLoadBalancerRequest, ApplySecurityGroupsToLoadBalancerResult> asyncHandler) {
        return this.executorService.submit(new Callable<ApplySecurityGroupsToLoadBalancerResult>(){

            @Override
            public ApplySecurityGroupsToLoadBalancerResult call() throws Exception {
                ApplySecurityGroupsToLoadBalancerResult result;
                try {
                    result = AmazonElasticLoadBalancingAsyncClient.this.applySecurityGroupsToLoadBalancer(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AttachLoadBalancerToSubnetsResult> attachLoadBalancerToSubnetsAsync(AttachLoadBalancerToSubnetsRequest request) {
        return this.attachLoadBalancerToSubnetsAsync(request, null);
    }

    @Override
    public Future<AttachLoadBalancerToSubnetsResult> attachLoadBalancerToSubnetsAsync(final AttachLoadBalancerToSubnetsRequest request, final AsyncHandler<AttachLoadBalancerToSubnetsRequest, AttachLoadBalancerToSubnetsResult> asyncHandler) {
        return this.executorService.submit(new Callable<AttachLoadBalancerToSubnetsResult>(){

            @Override
            public AttachLoadBalancerToSubnetsResult call() throws Exception {
                AttachLoadBalancerToSubnetsResult result;
                try {
                    result = AmazonElasticLoadBalancingAsyncClient.this.attachLoadBalancerToSubnets(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ConfigureHealthCheckResult> configureHealthCheckAsync(ConfigureHealthCheckRequest request) {
        return this.configureHealthCheckAsync(request, null);
    }

    @Override
    public Future<ConfigureHealthCheckResult> configureHealthCheckAsync(final ConfigureHealthCheckRequest request, final AsyncHandler<ConfigureHealthCheckRequest, ConfigureHealthCheckResult> asyncHandler) {
        return this.executorService.submit(new Callable<ConfigureHealthCheckResult>(){

            @Override
            public ConfigureHealthCheckResult call() throws Exception {
                ConfigureHealthCheckResult result;
                try {
                    result = AmazonElasticLoadBalancingAsyncClient.this.configureHealthCheck(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateAppCookieStickinessPolicyResult> createAppCookieStickinessPolicyAsync(CreateAppCookieStickinessPolicyRequest request) {
        return this.createAppCookieStickinessPolicyAsync(request, null);
    }

    @Override
    public Future<CreateAppCookieStickinessPolicyResult> createAppCookieStickinessPolicyAsync(final CreateAppCookieStickinessPolicyRequest request, final AsyncHandler<CreateAppCookieStickinessPolicyRequest, CreateAppCookieStickinessPolicyResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateAppCookieStickinessPolicyResult>(){

            @Override
            public CreateAppCookieStickinessPolicyResult call() throws Exception {
                CreateAppCookieStickinessPolicyResult result;
                try {
                    result = AmazonElasticLoadBalancingAsyncClient.this.createAppCookieStickinessPolicy(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateLBCookieStickinessPolicyResult> createLBCookieStickinessPolicyAsync(CreateLBCookieStickinessPolicyRequest request) {
        return this.createLBCookieStickinessPolicyAsync(request, null);
    }

    @Override
    public Future<CreateLBCookieStickinessPolicyResult> createLBCookieStickinessPolicyAsync(final CreateLBCookieStickinessPolicyRequest request, final AsyncHandler<CreateLBCookieStickinessPolicyRequest, CreateLBCookieStickinessPolicyResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateLBCookieStickinessPolicyResult>(){

            @Override
            public CreateLBCookieStickinessPolicyResult call() throws Exception {
                CreateLBCookieStickinessPolicyResult result;
                try {
                    result = AmazonElasticLoadBalancingAsyncClient.this.createLBCookieStickinessPolicy(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateLoadBalancerResult> createLoadBalancerAsync(CreateLoadBalancerRequest request) {
        return this.createLoadBalancerAsync(request, null);
    }

    @Override
    public Future<CreateLoadBalancerResult> createLoadBalancerAsync(final CreateLoadBalancerRequest request, final AsyncHandler<CreateLoadBalancerRequest, CreateLoadBalancerResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateLoadBalancerResult>(){

            @Override
            public CreateLoadBalancerResult call() throws Exception {
                CreateLoadBalancerResult result;
                try {
                    result = AmazonElasticLoadBalancingAsyncClient.this.createLoadBalancer(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateLoadBalancerListenersResult> createLoadBalancerListenersAsync(CreateLoadBalancerListenersRequest request) {
        return this.createLoadBalancerListenersAsync(request, null);
    }

    @Override
    public Future<CreateLoadBalancerListenersResult> createLoadBalancerListenersAsync(final CreateLoadBalancerListenersRequest request, final AsyncHandler<CreateLoadBalancerListenersRequest, CreateLoadBalancerListenersResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateLoadBalancerListenersResult>(){

            @Override
            public CreateLoadBalancerListenersResult call() throws Exception {
                CreateLoadBalancerListenersResult result;
                try {
                    result = AmazonElasticLoadBalancingAsyncClient.this.createLoadBalancerListeners(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateLoadBalancerPolicyResult> createLoadBalancerPolicyAsync(CreateLoadBalancerPolicyRequest request) {
        return this.createLoadBalancerPolicyAsync(request, null);
    }

    @Override
    public Future<CreateLoadBalancerPolicyResult> createLoadBalancerPolicyAsync(final CreateLoadBalancerPolicyRequest request, final AsyncHandler<CreateLoadBalancerPolicyRequest, CreateLoadBalancerPolicyResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateLoadBalancerPolicyResult>(){

            @Override
            public CreateLoadBalancerPolicyResult call() throws Exception {
                CreateLoadBalancerPolicyResult result;
                try {
                    result = AmazonElasticLoadBalancingAsyncClient.this.createLoadBalancerPolicy(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteLoadBalancerResult> deleteLoadBalancerAsync(DeleteLoadBalancerRequest request) {
        return this.deleteLoadBalancerAsync(request, null);
    }

    @Override
    public Future<DeleteLoadBalancerResult> deleteLoadBalancerAsync(final DeleteLoadBalancerRequest request, final AsyncHandler<DeleteLoadBalancerRequest, DeleteLoadBalancerResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteLoadBalancerResult>(){

            @Override
            public DeleteLoadBalancerResult call() throws Exception {
                DeleteLoadBalancerResult result;
                try {
                    result = AmazonElasticLoadBalancingAsyncClient.this.deleteLoadBalancer(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteLoadBalancerListenersResult> deleteLoadBalancerListenersAsync(DeleteLoadBalancerListenersRequest request) {
        return this.deleteLoadBalancerListenersAsync(request, null);
    }

    @Override
    public Future<DeleteLoadBalancerListenersResult> deleteLoadBalancerListenersAsync(final DeleteLoadBalancerListenersRequest request, final AsyncHandler<DeleteLoadBalancerListenersRequest, DeleteLoadBalancerListenersResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteLoadBalancerListenersResult>(){

            @Override
            public DeleteLoadBalancerListenersResult call() throws Exception {
                DeleteLoadBalancerListenersResult result;
                try {
                    result = AmazonElasticLoadBalancingAsyncClient.this.deleteLoadBalancerListeners(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteLoadBalancerPolicyResult> deleteLoadBalancerPolicyAsync(DeleteLoadBalancerPolicyRequest request) {
        return this.deleteLoadBalancerPolicyAsync(request, null);
    }

    @Override
    public Future<DeleteLoadBalancerPolicyResult> deleteLoadBalancerPolicyAsync(final DeleteLoadBalancerPolicyRequest request, final AsyncHandler<DeleteLoadBalancerPolicyRequest, DeleteLoadBalancerPolicyResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteLoadBalancerPolicyResult>(){

            @Override
            public DeleteLoadBalancerPolicyResult call() throws Exception {
                DeleteLoadBalancerPolicyResult result;
                try {
                    result = AmazonElasticLoadBalancingAsyncClient.this.deleteLoadBalancerPolicy(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeregisterInstancesFromLoadBalancerResult> deregisterInstancesFromLoadBalancerAsync(DeregisterInstancesFromLoadBalancerRequest request) {
        return this.deregisterInstancesFromLoadBalancerAsync(request, null);
    }

    @Override
    public Future<DeregisterInstancesFromLoadBalancerResult> deregisterInstancesFromLoadBalancerAsync(final DeregisterInstancesFromLoadBalancerRequest request, final AsyncHandler<DeregisterInstancesFromLoadBalancerRequest, DeregisterInstancesFromLoadBalancerResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeregisterInstancesFromLoadBalancerResult>(){

            @Override
            public DeregisterInstancesFromLoadBalancerResult call() throws Exception {
                DeregisterInstancesFromLoadBalancerResult result;
                try {
                    result = AmazonElasticLoadBalancingAsyncClient.this.deregisterInstancesFromLoadBalancer(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeInstanceHealthResult> describeInstanceHealthAsync(DescribeInstanceHealthRequest request) {
        return this.describeInstanceHealthAsync(request, null);
    }

    @Override
    public Future<DescribeInstanceHealthResult> describeInstanceHealthAsync(final DescribeInstanceHealthRequest request, final AsyncHandler<DescribeInstanceHealthRequest, DescribeInstanceHealthResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeInstanceHealthResult>(){

            @Override
            public DescribeInstanceHealthResult call() throws Exception {
                DescribeInstanceHealthResult result;
                try {
                    result = AmazonElasticLoadBalancingAsyncClient.this.describeInstanceHealth(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeLoadBalancerAttributesResult> describeLoadBalancerAttributesAsync(DescribeLoadBalancerAttributesRequest request) {
        return this.describeLoadBalancerAttributesAsync(request, null);
    }

    @Override
    public Future<DescribeLoadBalancerAttributesResult> describeLoadBalancerAttributesAsync(final DescribeLoadBalancerAttributesRequest request, final AsyncHandler<DescribeLoadBalancerAttributesRequest, DescribeLoadBalancerAttributesResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeLoadBalancerAttributesResult>(){

            @Override
            public DescribeLoadBalancerAttributesResult call() throws Exception {
                DescribeLoadBalancerAttributesResult result;
                try {
                    result = AmazonElasticLoadBalancingAsyncClient.this.describeLoadBalancerAttributes(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeLoadBalancerPoliciesResult> describeLoadBalancerPoliciesAsync(DescribeLoadBalancerPoliciesRequest request) {
        return this.describeLoadBalancerPoliciesAsync(request, null);
    }

    @Override
    public Future<DescribeLoadBalancerPoliciesResult> describeLoadBalancerPoliciesAsync(final DescribeLoadBalancerPoliciesRequest request, final AsyncHandler<DescribeLoadBalancerPoliciesRequest, DescribeLoadBalancerPoliciesResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeLoadBalancerPoliciesResult>(){

            @Override
            public DescribeLoadBalancerPoliciesResult call() throws Exception {
                DescribeLoadBalancerPoliciesResult result;
                try {
                    result = AmazonElasticLoadBalancingAsyncClient.this.describeLoadBalancerPolicies(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeLoadBalancerPoliciesResult> describeLoadBalancerPoliciesAsync() {
        return this.describeLoadBalancerPoliciesAsync(new DescribeLoadBalancerPoliciesRequest());
    }

    @Override
    public Future<DescribeLoadBalancerPoliciesResult> describeLoadBalancerPoliciesAsync(AsyncHandler<DescribeLoadBalancerPoliciesRequest, DescribeLoadBalancerPoliciesResult> asyncHandler) {
        return this.describeLoadBalancerPoliciesAsync(new DescribeLoadBalancerPoliciesRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeLoadBalancerPolicyTypesResult> describeLoadBalancerPolicyTypesAsync(DescribeLoadBalancerPolicyTypesRequest request) {
        return this.describeLoadBalancerPolicyTypesAsync(request, null);
    }

    @Override
    public Future<DescribeLoadBalancerPolicyTypesResult> describeLoadBalancerPolicyTypesAsync(final DescribeLoadBalancerPolicyTypesRequest request, final AsyncHandler<DescribeLoadBalancerPolicyTypesRequest, DescribeLoadBalancerPolicyTypesResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeLoadBalancerPolicyTypesResult>(){

            @Override
            public DescribeLoadBalancerPolicyTypesResult call() throws Exception {
                DescribeLoadBalancerPolicyTypesResult result;
                try {
                    result = AmazonElasticLoadBalancingAsyncClient.this.describeLoadBalancerPolicyTypes(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeLoadBalancerPolicyTypesResult> describeLoadBalancerPolicyTypesAsync() {
        return this.describeLoadBalancerPolicyTypesAsync(new DescribeLoadBalancerPolicyTypesRequest());
    }

    @Override
    public Future<DescribeLoadBalancerPolicyTypesResult> describeLoadBalancerPolicyTypesAsync(AsyncHandler<DescribeLoadBalancerPolicyTypesRequest, DescribeLoadBalancerPolicyTypesResult> asyncHandler) {
        return this.describeLoadBalancerPolicyTypesAsync(new DescribeLoadBalancerPolicyTypesRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeLoadBalancersResult> describeLoadBalancersAsync(DescribeLoadBalancersRequest request) {
        return this.describeLoadBalancersAsync(request, null);
    }

    @Override
    public Future<DescribeLoadBalancersResult> describeLoadBalancersAsync(final DescribeLoadBalancersRequest request, final AsyncHandler<DescribeLoadBalancersRequest, DescribeLoadBalancersResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeLoadBalancersResult>(){

            @Override
            public DescribeLoadBalancersResult call() throws Exception {
                DescribeLoadBalancersResult result;
                try {
                    result = AmazonElasticLoadBalancingAsyncClient.this.describeLoadBalancers(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeLoadBalancersResult> describeLoadBalancersAsync() {
        return this.describeLoadBalancersAsync(new DescribeLoadBalancersRequest());
    }

    @Override
    public Future<DescribeLoadBalancersResult> describeLoadBalancersAsync(AsyncHandler<DescribeLoadBalancersRequest, DescribeLoadBalancersResult> asyncHandler) {
        return this.describeLoadBalancersAsync(new DescribeLoadBalancersRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeTagsResult> describeTagsAsync(DescribeTagsRequest request) {
        return this.describeTagsAsync(request, null);
    }

    @Override
    public Future<DescribeTagsResult> describeTagsAsync(final DescribeTagsRequest request, final AsyncHandler<DescribeTagsRequest, DescribeTagsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeTagsResult>(){

            @Override
            public DescribeTagsResult call() throws Exception {
                DescribeTagsResult result;
                try {
                    result = AmazonElasticLoadBalancingAsyncClient.this.describeTags(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DetachLoadBalancerFromSubnetsResult> detachLoadBalancerFromSubnetsAsync(DetachLoadBalancerFromSubnetsRequest request) {
        return this.detachLoadBalancerFromSubnetsAsync(request, null);
    }

    @Override
    public Future<DetachLoadBalancerFromSubnetsResult> detachLoadBalancerFromSubnetsAsync(final DetachLoadBalancerFromSubnetsRequest request, final AsyncHandler<DetachLoadBalancerFromSubnetsRequest, DetachLoadBalancerFromSubnetsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DetachLoadBalancerFromSubnetsResult>(){

            @Override
            public DetachLoadBalancerFromSubnetsResult call() throws Exception {
                DetachLoadBalancerFromSubnetsResult result;
                try {
                    result = AmazonElasticLoadBalancingAsyncClient.this.detachLoadBalancerFromSubnets(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisableAvailabilityZonesForLoadBalancerResult> disableAvailabilityZonesForLoadBalancerAsync(DisableAvailabilityZonesForLoadBalancerRequest request) {
        return this.disableAvailabilityZonesForLoadBalancerAsync(request, null);
    }

    @Override
    public Future<DisableAvailabilityZonesForLoadBalancerResult> disableAvailabilityZonesForLoadBalancerAsync(final DisableAvailabilityZonesForLoadBalancerRequest request, final AsyncHandler<DisableAvailabilityZonesForLoadBalancerRequest, DisableAvailabilityZonesForLoadBalancerResult> asyncHandler) {
        return this.executorService.submit(new Callable<DisableAvailabilityZonesForLoadBalancerResult>(){

            @Override
            public DisableAvailabilityZonesForLoadBalancerResult call() throws Exception {
                DisableAvailabilityZonesForLoadBalancerResult result;
                try {
                    result = AmazonElasticLoadBalancingAsyncClient.this.disableAvailabilityZonesForLoadBalancer(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<EnableAvailabilityZonesForLoadBalancerResult> enableAvailabilityZonesForLoadBalancerAsync(EnableAvailabilityZonesForLoadBalancerRequest request) {
        return this.enableAvailabilityZonesForLoadBalancerAsync(request, null);
    }

    @Override
    public Future<EnableAvailabilityZonesForLoadBalancerResult> enableAvailabilityZonesForLoadBalancerAsync(final EnableAvailabilityZonesForLoadBalancerRequest request, final AsyncHandler<EnableAvailabilityZonesForLoadBalancerRequest, EnableAvailabilityZonesForLoadBalancerResult> asyncHandler) {
        return this.executorService.submit(new Callable<EnableAvailabilityZonesForLoadBalancerResult>(){

            @Override
            public EnableAvailabilityZonesForLoadBalancerResult call() throws Exception {
                EnableAvailabilityZonesForLoadBalancerResult result;
                try {
                    result = AmazonElasticLoadBalancingAsyncClient.this.enableAvailabilityZonesForLoadBalancer(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ModifyLoadBalancerAttributesResult> modifyLoadBalancerAttributesAsync(ModifyLoadBalancerAttributesRequest request) {
        return this.modifyLoadBalancerAttributesAsync(request, null);
    }

    @Override
    public Future<ModifyLoadBalancerAttributesResult> modifyLoadBalancerAttributesAsync(final ModifyLoadBalancerAttributesRequest request, final AsyncHandler<ModifyLoadBalancerAttributesRequest, ModifyLoadBalancerAttributesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ModifyLoadBalancerAttributesResult>(){

            @Override
            public ModifyLoadBalancerAttributesResult call() throws Exception {
                ModifyLoadBalancerAttributesResult result;
                try {
                    result = AmazonElasticLoadBalancingAsyncClient.this.modifyLoadBalancerAttributes(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RegisterInstancesWithLoadBalancerResult> registerInstancesWithLoadBalancerAsync(RegisterInstancesWithLoadBalancerRequest request) {
        return this.registerInstancesWithLoadBalancerAsync(request, null);
    }

    @Override
    public Future<RegisterInstancesWithLoadBalancerResult> registerInstancesWithLoadBalancerAsync(final RegisterInstancesWithLoadBalancerRequest request, final AsyncHandler<RegisterInstancesWithLoadBalancerRequest, RegisterInstancesWithLoadBalancerResult> asyncHandler) {
        return this.executorService.submit(new Callable<RegisterInstancesWithLoadBalancerResult>(){

            @Override
            public RegisterInstancesWithLoadBalancerResult call() throws Exception {
                RegisterInstancesWithLoadBalancerResult result;
                try {
                    result = AmazonElasticLoadBalancingAsyncClient.this.registerInstancesWithLoadBalancer(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RemoveTagsResult> removeTagsAsync(RemoveTagsRequest request) {
        return this.removeTagsAsync(request, null);
    }

    @Override
    public Future<RemoveTagsResult> removeTagsAsync(final RemoveTagsRequest request, final AsyncHandler<RemoveTagsRequest, RemoveTagsResult> asyncHandler) {
        return this.executorService.submit(new Callable<RemoveTagsResult>(){

            @Override
            public RemoveTagsResult call() throws Exception {
                RemoveTagsResult result;
                try {
                    result = AmazonElasticLoadBalancingAsyncClient.this.removeTags(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SetLoadBalancerListenerSSLCertificateResult> setLoadBalancerListenerSSLCertificateAsync(SetLoadBalancerListenerSSLCertificateRequest request) {
        return this.setLoadBalancerListenerSSLCertificateAsync(request, null);
    }

    @Override
    public Future<SetLoadBalancerListenerSSLCertificateResult> setLoadBalancerListenerSSLCertificateAsync(final SetLoadBalancerListenerSSLCertificateRequest request, final AsyncHandler<SetLoadBalancerListenerSSLCertificateRequest, SetLoadBalancerListenerSSLCertificateResult> asyncHandler) {
        return this.executorService.submit(new Callable<SetLoadBalancerListenerSSLCertificateResult>(){

            @Override
            public SetLoadBalancerListenerSSLCertificateResult call() throws Exception {
                SetLoadBalancerListenerSSLCertificateResult result;
                try {
                    result = AmazonElasticLoadBalancingAsyncClient.this.setLoadBalancerListenerSSLCertificate(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SetLoadBalancerPoliciesForBackendServerResult> setLoadBalancerPoliciesForBackendServerAsync(SetLoadBalancerPoliciesForBackendServerRequest request) {
        return this.setLoadBalancerPoliciesForBackendServerAsync(request, null);
    }

    @Override
    public Future<SetLoadBalancerPoliciesForBackendServerResult> setLoadBalancerPoliciesForBackendServerAsync(final SetLoadBalancerPoliciesForBackendServerRequest request, final AsyncHandler<SetLoadBalancerPoliciesForBackendServerRequest, SetLoadBalancerPoliciesForBackendServerResult> asyncHandler) {
        return this.executorService.submit(new Callable<SetLoadBalancerPoliciesForBackendServerResult>(){

            @Override
            public SetLoadBalancerPoliciesForBackendServerResult call() throws Exception {
                SetLoadBalancerPoliciesForBackendServerResult result;
                try {
                    result = AmazonElasticLoadBalancingAsyncClient.this.setLoadBalancerPoliciesForBackendServer(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SetLoadBalancerPoliciesOfListenerResult> setLoadBalancerPoliciesOfListenerAsync(SetLoadBalancerPoliciesOfListenerRequest request) {
        return this.setLoadBalancerPoliciesOfListenerAsync(request, null);
    }

    @Override
    public Future<SetLoadBalancerPoliciesOfListenerResult> setLoadBalancerPoliciesOfListenerAsync(final SetLoadBalancerPoliciesOfListenerRequest request, final AsyncHandler<SetLoadBalancerPoliciesOfListenerRequest, SetLoadBalancerPoliciesOfListenerResult> asyncHandler) {
        return this.executorService.submit(new Callable<SetLoadBalancerPoliciesOfListenerResult>(){

            @Override
            public SetLoadBalancerPoliciesOfListenerResult call() throws Exception {
                SetLoadBalancerPoliciesOfListenerResult result;
                try {
                    result = AmazonElasticLoadBalancingAsyncClient.this.setLoadBalancerPoliciesOfListener(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

