/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.datapipeline.model.PipelineObject;
import com.amazonaws.services.datapipeline.model.TaskObject;
import com.amazonaws.services.datapipeline.model.transform.PipelineObjectJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;
import java.util.Map;

public class TaskObjectJsonMarshaller {
    private static TaskObjectJsonMarshaller instance;

    public void marshall(TaskObject taskObject, JSONWriter jsonWriter) {
        if (taskObject == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            Map<String, PipelineObject> objectsMap;
            jsonWriter.object();
            if (taskObject.getTaskId() != null) {
                jsonWriter.key("taskId").value(taskObject.getTaskId());
            }
            if (taskObject.getPipelineId() != null) {
                jsonWriter.key("pipelineId").value(taskObject.getPipelineId());
            }
            if (taskObject.getAttemptId() != null) {
                jsonWriter.key("attemptId").value(taskObject.getAttemptId());
            }
            if ((objectsMap = taskObject.getObjects()) != null) {
                jsonWriter.key("objects");
                jsonWriter.object();
                for (Map.Entry<String, PipelineObject> objectsMapValue : objectsMap.entrySet()) {
                    if (objectsMapValue.getValue() == null) continue;
                    jsonWriter.key(objectsMapValue.getKey());
                    PipelineObjectJsonMarshaller.getInstance().marshall(objectsMapValue.getValue(), jsonWriter);
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static TaskObjectJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new TaskObjectJsonMarshaller();
        }
        return instance;
    }
}

