/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.GetExportRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.util.Map;

public class GetExportRequestMarshaller
implements Marshaller<Request<GetExportRequest>, GetExportRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<GetExportRequest> marshall(GetExportRequest getExportRequest) {
        if (getExportRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetExportRequest> request = new DefaultRequest<GetExportRequest>(getExportRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.GET);
        if (getExportRequest.getAccepts() != null) {
            request.addHeader("Accept", StringUtils.fromString(getExportRequest.getAccepts()));
        }
        String uriResourcePath = "/restapis/{restapi_id}/stages/{stage_name}/exports/{export_type}";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", getExportRequest.getRestApiId() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString(getExportRequest.getRestApiId()));
        uriResourcePath = uriResourcePath.replace("{stage_name}", getExportRequest.getStageName() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString(getExportRequest.getStageName()));
        uriResourcePath = uriResourcePath.replace("{export_type}", getExportRequest.getExportType() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString(getExportRequest.getExportType()));
        request.setResourcePath(uriResourcePath);
        Map<String, String> parameters = getExportRequest.getParameters();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            if (entry.getValue() == null) continue;
            request.addParameter(StringUtils.fromString(entry.getKey()), StringUtils.fromString(entry.getValue()));
        }
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

