/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.logs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.logs.model.DescribeLogGroupsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class DescribeLogGroupsRequestMarshaller
implements Marshaller<Request<DescribeLogGroupsRequest>, DescribeLogGroupsRequest> {
    @Override
    public Request<DescribeLogGroupsRequest> marshall(DescribeLogGroupsRequest describeLogGroupsRequest) {
        if (describeLogGroupsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeLogGroupsRequest> request = new DefaultRequest<DescribeLogGroupsRequest>(describeLogGroupsRequest, "AWSLogs");
        request.addHeader("X-Amz-Target", "Logs_20140328.DescribeLogGroups");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (describeLogGroupsRequest.getLogGroupNamePrefix() != null) {
                jsonWriter.key("logGroupNamePrefix").value(describeLogGroupsRequest.getLogGroupNamePrefix());
            }
            if (describeLogGroupsRequest.getNextToken() != null) {
                jsonWriter.key("nextToken").value(describeLogGroupsRequest.getNextToken());
            }
            if (describeLogGroupsRequest.getLimit() != null) {
                jsonWriter.key("limit").value(describeLogGroupsRequest.getLimit());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

