/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.PredefinedClientConfigurations;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.codedeploy.AmazonCodeDeployAsync;
import com.amazonaws.services.codedeploy.AmazonCodeDeployClient;
import com.amazonaws.services.codedeploy.model.AddTagsToOnPremisesInstancesRequest;
import com.amazonaws.services.codedeploy.model.BatchGetApplicationsRequest;
import com.amazonaws.services.codedeploy.model.BatchGetApplicationsResult;
import com.amazonaws.services.codedeploy.model.BatchGetDeploymentsRequest;
import com.amazonaws.services.codedeploy.model.BatchGetDeploymentsResult;
import com.amazonaws.services.codedeploy.model.BatchGetOnPremisesInstancesRequest;
import com.amazonaws.services.codedeploy.model.BatchGetOnPremisesInstancesResult;
import com.amazonaws.services.codedeploy.model.CreateApplicationRequest;
import com.amazonaws.services.codedeploy.model.CreateApplicationResult;
import com.amazonaws.services.codedeploy.model.CreateDeploymentConfigRequest;
import com.amazonaws.services.codedeploy.model.CreateDeploymentConfigResult;
import com.amazonaws.services.codedeploy.model.CreateDeploymentGroupRequest;
import com.amazonaws.services.codedeploy.model.CreateDeploymentGroupResult;
import com.amazonaws.services.codedeploy.model.CreateDeploymentRequest;
import com.amazonaws.services.codedeploy.model.CreateDeploymentResult;
import com.amazonaws.services.codedeploy.model.DeleteApplicationRequest;
import com.amazonaws.services.codedeploy.model.DeleteDeploymentConfigRequest;
import com.amazonaws.services.codedeploy.model.DeleteDeploymentGroupRequest;
import com.amazonaws.services.codedeploy.model.DeleteDeploymentGroupResult;
import com.amazonaws.services.codedeploy.model.DeregisterOnPremisesInstanceRequest;
import com.amazonaws.services.codedeploy.model.GetApplicationRequest;
import com.amazonaws.services.codedeploy.model.GetApplicationResult;
import com.amazonaws.services.codedeploy.model.GetApplicationRevisionRequest;
import com.amazonaws.services.codedeploy.model.GetApplicationRevisionResult;
import com.amazonaws.services.codedeploy.model.GetDeploymentConfigRequest;
import com.amazonaws.services.codedeploy.model.GetDeploymentConfigResult;
import com.amazonaws.services.codedeploy.model.GetDeploymentGroupRequest;
import com.amazonaws.services.codedeploy.model.GetDeploymentGroupResult;
import com.amazonaws.services.codedeploy.model.GetDeploymentInstanceRequest;
import com.amazonaws.services.codedeploy.model.GetDeploymentInstanceResult;
import com.amazonaws.services.codedeploy.model.GetDeploymentRequest;
import com.amazonaws.services.codedeploy.model.GetDeploymentResult;
import com.amazonaws.services.codedeploy.model.GetOnPremisesInstanceRequest;
import com.amazonaws.services.codedeploy.model.GetOnPremisesInstanceResult;
import com.amazonaws.services.codedeploy.model.ListApplicationRevisionsRequest;
import com.amazonaws.services.codedeploy.model.ListApplicationRevisionsResult;
import com.amazonaws.services.codedeploy.model.ListApplicationsRequest;
import com.amazonaws.services.codedeploy.model.ListApplicationsResult;
import com.amazonaws.services.codedeploy.model.ListDeploymentConfigsRequest;
import com.amazonaws.services.codedeploy.model.ListDeploymentConfigsResult;
import com.amazonaws.services.codedeploy.model.ListDeploymentGroupsRequest;
import com.amazonaws.services.codedeploy.model.ListDeploymentGroupsResult;
import com.amazonaws.services.codedeploy.model.ListDeploymentInstancesRequest;
import com.amazonaws.services.codedeploy.model.ListDeploymentInstancesResult;
import com.amazonaws.services.codedeploy.model.ListDeploymentsRequest;
import com.amazonaws.services.codedeploy.model.ListDeploymentsResult;
import com.amazonaws.services.codedeploy.model.ListOnPremisesInstancesRequest;
import com.amazonaws.services.codedeploy.model.ListOnPremisesInstancesResult;
import com.amazonaws.services.codedeploy.model.RegisterApplicationRevisionRequest;
import com.amazonaws.services.codedeploy.model.RegisterOnPremisesInstanceRequest;
import com.amazonaws.services.codedeploy.model.RemoveTagsFromOnPremisesInstancesRequest;
import com.amazonaws.services.codedeploy.model.StopDeploymentRequest;
import com.amazonaws.services.codedeploy.model.StopDeploymentResult;
import com.amazonaws.services.codedeploy.model.UpdateApplicationRequest;
import com.amazonaws.services.codedeploy.model.UpdateDeploymentGroupRequest;
import com.amazonaws.services.codedeploy.model.UpdateDeploymentGroupResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AmazonCodeDeployAsyncClient
extends AmazonCodeDeployClient
implements AmazonCodeDeployAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public AmazonCodeDeployAsyncClient() {
        this(new DefaultAWSCredentialsProviderChain());
    }

    public AmazonCodeDeployAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonCodeDeployAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AmazonCodeDeployAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, PredefinedClientConfigurations.defaultConfig(), executorService);
    }

    public AmazonCodeDeployAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonCodeDeployAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AmazonCodeDeployAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonCodeDeployAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, PredefinedClientConfigurations.defaultConfig(), executorService);
    }

    public AmazonCodeDeployAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<Void> addTagsToOnPremisesInstancesAsync(AddTagsToOnPremisesInstancesRequest request) {
        return this.addTagsToOnPremisesInstancesAsync(request, null);
    }

    @Override
    public Future<Void> addTagsToOnPremisesInstancesAsync(final AddTagsToOnPremisesInstancesRequest request, final AsyncHandler<AddTagsToOnPremisesInstancesRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonCodeDeployAsyncClient.this.addTagsToOnPremisesInstances(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchGetApplicationsResult> batchGetApplicationsAsync(BatchGetApplicationsRequest request) {
        return this.batchGetApplicationsAsync(request, null);
    }

    @Override
    public Future<BatchGetApplicationsResult> batchGetApplicationsAsync(final BatchGetApplicationsRequest request, final AsyncHandler<BatchGetApplicationsRequest, BatchGetApplicationsResult> asyncHandler) {
        return this.executorService.submit(new Callable<BatchGetApplicationsResult>(){

            @Override
            public BatchGetApplicationsResult call() throws Exception {
                BatchGetApplicationsResult result;
                try {
                    result = AmazonCodeDeployAsyncClient.this.batchGetApplications(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchGetApplicationsResult> batchGetApplicationsAsync() {
        return this.batchGetApplicationsAsync(new BatchGetApplicationsRequest());
    }

    @Override
    public Future<BatchGetApplicationsResult> batchGetApplicationsAsync(AsyncHandler<BatchGetApplicationsRequest, BatchGetApplicationsResult> asyncHandler) {
        return this.batchGetApplicationsAsync(new BatchGetApplicationsRequest(), asyncHandler);
    }

    @Override
    public Future<BatchGetDeploymentsResult> batchGetDeploymentsAsync(BatchGetDeploymentsRequest request) {
        return this.batchGetDeploymentsAsync(request, null);
    }

    @Override
    public Future<BatchGetDeploymentsResult> batchGetDeploymentsAsync(final BatchGetDeploymentsRequest request, final AsyncHandler<BatchGetDeploymentsRequest, BatchGetDeploymentsResult> asyncHandler) {
        return this.executorService.submit(new Callable<BatchGetDeploymentsResult>(){

            @Override
            public BatchGetDeploymentsResult call() throws Exception {
                BatchGetDeploymentsResult result;
                try {
                    result = AmazonCodeDeployAsyncClient.this.batchGetDeployments(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchGetDeploymentsResult> batchGetDeploymentsAsync() {
        return this.batchGetDeploymentsAsync(new BatchGetDeploymentsRequest());
    }

    @Override
    public Future<BatchGetDeploymentsResult> batchGetDeploymentsAsync(AsyncHandler<BatchGetDeploymentsRequest, BatchGetDeploymentsResult> asyncHandler) {
        return this.batchGetDeploymentsAsync(new BatchGetDeploymentsRequest(), asyncHandler);
    }

    @Override
    public Future<BatchGetOnPremisesInstancesResult> batchGetOnPremisesInstancesAsync(BatchGetOnPremisesInstancesRequest request) {
        return this.batchGetOnPremisesInstancesAsync(request, null);
    }

    @Override
    public Future<BatchGetOnPremisesInstancesResult> batchGetOnPremisesInstancesAsync(final BatchGetOnPremisesInstancesRequest request, final AsyncHandler<BatchGetOnPremisesInstancesRequest, BatchGetOnPremisesInstancesResult> asyncHandler) {
        return this.executorService.submit(new Callable<BatchGetOnPremisesInstancesResult>(){

            @Override
            public BatchGetOnPremisesInstancesResult call() throws Exception {
                BatchGetOnPremisesInstancesResult result;
                try {
                    result = AmazonCodeDeployAsyncClient.this.batchGetOnPremisesInstances(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchGetOnPremisesInstancesResult> batchGetOnPremisesInstancesAsync() {
        return this.batchGetOnPremisesInstancesAsync(new BatchGetOnPremisesInstancesRequest());
    }

    @Override
    public Future<BatchGetOnPremisesInstancesResult> batchGetOnPremisesInstancesAsync(AsyncHandler<BatchGetOnPremisesInstancesRequest, BatchGetOnPremisesInstancesResult> asyncHandler) {
        return this.batchGetOnPremisesInstancesAsync(new BatchGetOnPremisesInstancesRequest(), asyncHandler);
    }

    @Override
    public Future<CreateApplicationResult> createApplicationAsync(CreateApplicationRequest request) {
        return this.createApplicationAsync(request, null);
    }

    @Override
    public Future<CreateApplicationResult> createApplicationAsync(final CreateApplicationRequest request, final AsyncHandler<CreateApplicationRequest, CreateApplicationResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateApplicationResult>(){

            @Override
            public CreateApplicationResult call() throws Exception {
                CreateApplicationResult result;
                try {
                    result = AmazonCodeDeployAsyncClient.this.createApplication(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateDeploymentResult> createDeploymentAsync(CreateDeploymentRequest request) {
        return this.createDeploymentAsync(request, null);
    }

    @Override
    public Future<CreateDeploymentResult> createDeploymentAsync(final CreateDeploymentRequest request, final AsyncHandler<CreateDeploymentRequest, CreateDeploymentResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateDeploymentResult>(){

            @Override
            public CreateDeploymentResult call() throws Exception {
                CreateDeploymentResult result;
                try {
                    result = AmazonCodeDeployAsyncClient.this.createDeployment(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateDeploymentConfigResult> createDeploymentConfigAsync(CreateDeploymentConfigRequest request) {
        return this.createDeploymentConfigAsync(request, null);
    }

    @Override
    public Future<CreateDeploymentConfigResult> createDeploymentConfigAsync(final CreateDeploymentConfigRequest request, final AsyncHandler<CreateDeploymentConfigRequest, CreateDeploymentConfigResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateDeploymentConfigResult>(){

            @Override
            public CreateDeploymentConfigResult call() throws Exception {
                CreateDeploymentConfigResult result;
                try {
                    result = AmazonCodeDeployAsyncClient.this.createDeploymentConfig(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateDeploymentGroupResult> createDeploymentGroupAsync(CreateDeploymentGroupRequest request) {
        return this.createDeploymentGroupAsync(request, null);
    }

    @Override
    public Future<CreateDeploymentGroupResult> createDeploymentGroupAsync(final CreateDeploymentGroupRequest request, final AsyncHandler<CreateDeploymentGroupRequest, CreateDeploymentGroupResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateDeploymentGroupResult>(){

            @Override
            public CreateDeploymentGroupResult call() throws Exception {
                CreateDeploymentGroupResult result;
                try {
                    result = AmazonCodeDeployAsyncClient.this.createDeploymentGroup(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteApplicationAsync(DeleteApplicationRequest request) {
        return this.deleteApplicationAsync(request, null);
    }

    @Override
    public Future<Void> deleteApplicationAsync(final DeleteApplicationRequest request, final AsyncHandler<DeleteApplicationRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonCodeDeployAsyncClient.this.deleteApplication(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteDeploymentConfigAsync(DeleteDeploymentConfigRequest request) {
        return this.deleteDeploymentConfigAsync(request, null);
    }

    @Override
    public Future<Void> deleteDeploymentConfigAsync(final DeleteDeploymentConfigRequest request, final AsyncHandler<DeleteDeploymentConfigRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonCodeDeployAsyncClient.this.deleteDeploymentConfig(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteDeploymentGroupResult> deleteDeploymentGroupAsync(DeleteDeploymentGroupRequest request) {
        return this.deleteDeploymentGroupAsync(request, null);
    }

    @Override
    public Future<DeleteDeploymentGroupResult> deleteDeploymentGroupAsync(final DeleteDeploymentGroupRequest request, final AsyncHandler<DeleteDeploymentGroupRequest, DeleteDeploymentGroupResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteDeploymentGroupResult>(){

            @Override
            public DeleteDeploymentGroupResult call() throws Exception {
                DeleteDeploymentGroupResult result;
                try {
                    result = AmazonCodeDeployAsyncClient.this.deleteDeploymentGroup(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> deregisterOnPremisesInstanceAsync(DeregisterOnPremisesInstanceRequest request) {
        return this.deregisterOnPremisesInstanceAsync(request, null);
    }

    @Override
    public Future<Void> deregisterOnPremisesInstanceAsync(final DeregisterOnPremisesInstanceRequest request, final AsyncHandler<DeregisterOnPremisesInstanceRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonCodeDeployAsyncClient.this.deregisterOnPremisesInstance(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetApplicationResult> getApplicationAsync(GetApplicationRequest request) {
        return this.getApplicationAsync(request, null);
    }

    @Override
    public Future<GetApplicationResult> getApplicationAsync(final GetApplicationRequest request, final AsyncHandler<GetApplicationRequest, GetApplicationResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetApplicationResult>(){

            @Override
            public GetApplicationResult call() throws Exception {
                GetApplicationResult result;
                try {
                    result = AmazonCodeDeployAsyncClient.this.getApplication(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetApplicationRevisionResult> getApplicationRevisionAsync(GetApplicationRevisionRequest request) {
        return this.getApplicationRevisionAsync(request, null);
    }

    @Override
    public Future<GetApplicationRevisionResult> getApplicationRevisionAsync(final GetApplicationRevisionRequest request, final AsyncHandler<GetApplicationRevisionRequest, GetApplicationRevisionResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetApplicationRevisionResult>(){

            @Override
            public GetApplicationRevisionResult call() throws Exception {
                GetApplicationRevisionResult result;
                try {
                    result = AmazonCodeDeployAsyncClient.this.getApplicationRevision(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDeploymentResult> getDeploymentAsync(GetDeploymentRequest request) {
        return this.getDeploymentAsync(request, null);
    }

    @Override
    public Future<GetDeploymentResult> getDeploymentAsync(final GetDeploymentRequest request, final AsyncHandler<GetDeploymentRequest, GetDeploymentResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetDeploymentResult>(){

            @Override
            public GetDeploymentResult call() throws Exception {
                GetDeploymentResult result;
                try {
                    result = AmazonCodeDeployAsyncClient.this.getDeployment(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDeploymentConfigResult> getDeploymentConfigAsync(GetDeploymentConfigRequest request) {
        return this.getDeploymentConfigAsync(request, null);
    }

    @Override
    public Future<GetDeploymentConfigResult> getDeploymentConfigAsync(final GetDeploymentConfigRequest request, final AsyncHandler<GetDeploymentConfigRequest, GetDeploymentConfigResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetDeploymentConfigResult>(){

            @Override
            public GetDeploymentConfigResult call() throws Exception {
                GetDeploymentConfigResult result;
                try {
                    result = AmazonCodeDeployAsyncClient.this.getDeploymentConfig(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDeploymentGroupResult> getDeploymentGroupAsync(GetDeploymentGroupRequest request) {
        return this.getDeploymentGroupAsync(request, null);
    }

    @Override
    public Future<GetDeploymentGroupResult> getDeploymentGroupAsync(final GetDeploymentGroupRequest request, final AsyncHandler<GetDeploymentGroupRequest, GetDeploymentGroupResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetDeploymentGroupResult>(){

            @Override
            public GetDeploymentGroupResult call() throws Exception {
                GetDeploymentGroupResult result;
                try {
                    result = AmazonCodeDeployAsyncClient.this.getDeploymentGroup(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDeploymentInstanceResult> getDeploymentInstanceAsync(GetDeploymentInstanceRequest request) {
        return this.getDeploymentInstanceAsync(request, null);
    }

    @Override
    public Future<GetDeploymentInstanceResult> getDeploymentInstanceAsync(final GetDeploymentInstanceRequest request, final AsyncHandler<GetDeploymentInstanceRequest, GetDeploymentInstanceResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetDeploymentInstanceResult>(){

            @Override
            public GetDeploymentInstanceResult call() throws Exception {
                GetDeploymentInstanceResult result;
                try {
                    result = AmazonCodeDeployAsyncClient.this.getDeploymentInstance(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetOnPremisesInstanceResult> getOnPremisesInstanceAsync(GetOnPremisesInstanceRequest request) {
        return this.getOnPremisesInstanceAsync(request, null);
    }

    @Override
    public Future<GetOnPremisesInstanceResult> getOnPremisesInstanceAsync(final GetOnPremisesInstanceRequest request, final AsyncHandler<GetOnPremisesInstanceRequest, GetOnPremisesInstanceResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetOnPremisesInstanceResult>(){

            @Override
            public GetOnPremisesInstanceResult call() throws Exception {
                GetOnPremisesInstanceResult result;
                try {
                    result = AmazonCodeDeployAsyncClient.this.getOnPremisesInstance(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListApplicationRevisionsResult> listApplicationRevisionsAsync(ListApplicationRevisionsRequest request) {
        return this.listApplicationRevisionsAsync(request, null);
    }

    @Override
    public Future<ListApplicationRevisionsResult> listApplicationRevisionsAsync(final ListApplicationRevisionsRequest request, final AsyncHandler<ListApplicationRevisionsRequest, ListApplicationRevisionsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListApplicationRevisionsResult>(){

            @Override
            public ListApplicationRevisionsResult call() throws Exception {
                ListApplicationRevisionsResult result;
                try {
                    result = AmazonCodeDeployAsyncClient.this.listApplicationRevisions(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListApplicationsResult> listApplicationsAsync(ListApplicationsRequest request) {
        return this.listApplicationsAsync(request, null);
    }

    @Override
    public Future<ListApplicationsResult> listApplicationsAsync(final ListApplicationsRequest request, final AsyncHandler<ListApplicationsRequest, ListApplicationsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListApplicationsResult>(){

            @Override
            public ListApplicationsResult call() throws Exception {
                ListApplicationsResult result;
                try {
                    result = AmazonCodeDeployAsyncClient.this.listApplications(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListApplicationsResult> listApplicationsAsync() {
        return this.listApplicationsAsync(new ListApplicationsRequest());
    }

    @Override
    public Future<ListApplicationsResult> listApplicationsAsync(AsyncHandler<ListApplicationsRequest, ListApplicationsResult> asyncHandler) {
        return this.listApplicationsAsync(new ListApplicationsRequest(), asyncHandler);
    }

    @Override
    public Future<ListDeploymentConfigsResult> listDeploymentConfigsAsync(ListDeploymentConfigsRequest request) {
        return this.listDeploymentConfigsAsync(request, null);
    }

    @Override
    public Future<ListDeploymentConfigsResult> listDeploymentConfigsAsync(final ListDeploymentConfigsRequest request, final AsyncHandler<ListDeploymentConfigsRequest, ListDeploymentConfigsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListDeploymentConfigsResult>(){

            @Override
            public ListDeploymentConfigsResult call() throws Exception {
                ListDeploymentConfigsResult result;
                try {
                    result = AmazonCodeDeployAsyncClient.this.listDeploymentConfigs(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDeploymentConfigsResult> listDeploymentConfigsAsync() {
        return this.listDeploymentConfigsAsync(new ListDeploymentConfigsRequest());
    }

    @Override
    public Future<ListDeploymentConfigsResult> listDeploymentConfigsAsync(AsyncHandler<ListDeploymentConfigsRequest, ListDeploymentConfigsResult> asyncHandler) {
        return this.listDeploymentConfigsAsync(new ListDeploymentConfigsRequest(), asyncHandler);
    }

    @Override
    public Future<ListDeploymentGroupsResult> listDeploymentGroupsAsync(ListDeploymentGroupsRequest request) {
        return this.listDeploymentGroupsAsync(request, null);
    }

    @Override
    public Future<ListDeploymentGroupsResult> listDeploymentGroupsAsync(final ListDeploymentGroupsRequest request, final AsyncHandler<ListDeploymentGroupsRequest, ListDeploymentGroupsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListDeploymentGroupsResult>(){

            @Override
            public ListDeploymentGroupsResult call() throws Exception {
                ListDeploymentGroupsResult result;
                try {
                    result = AmazonCodeDeployAsyncClient.this.listDeploymentGroups(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDeploymentInstancesResult> listDeploymentInstancesAsync(ListDeploymentInstancesRequest request) {
        return this.listDeploymentInstancesAsync(request, null);
    }

    @Override
    public Future<ListDeploymentInstancesResult> listDeploymentInstancesAsync(final ListDeploymentInstancesRequest request, final AsyncHandler<ListDeploymentInstancesRequest, ListDeploymentInstancesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListDeploymentInstancesResult>(){

            @Override
            public ListDeploymentInstancesResult call() throws Exception {
                ListDeploymentInstancesResult result;
                try {
                    result = AmazonCodeDeployAsyncClient.this.listDeploymentInstances(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDeploymentsResult> listDeploymentsAsync(ListDeploymentsRequest request) {
        return this.listDeploymentsAsync(request, null);
    }

    @Override
    public Future<ListDeploymentsResult> listDeploymentsAsync(final ListDeploymentsRequest request, final AsyncHandler<ListDeploymentsRequest, ListDeploymentsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListDeploymentsResult>(){

            @Override
            public ListDeploymentsResult call() throws Exception {
                ListDeploymentsResult result;
                try {
                    result = AmazonCodeDeployAsyncClient.this.listDeployments(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDeploymentsResult> listDeploymentsAsync() {
        return this.listDeploymentsAsync(new ListDeploymentsRequest());
    }

    @Override
    public Future<ListDeploymentsResult> listDeploymentsAsync(AsyncHandler<ListDeploymentsRequest, ListDeploymentsResult> asyncHandler) {
        return this.listDeploymentsAsync(new ListDeploymentsRequest(), asyncHandler);
    }

    @Override
    public Future<ListOnPremisesInstancesResult> listOnPremisesInstancesAsync(ListOnPremisesInstancesRequest request) {
        return this.listOnPremisesInstancesAsync(request, null);
    }

    @Override
    public Future<ListOnPremisesInstancesResult> listOnPremisesInstancesAsync(final ListOnPremisesInstancesRequest request, final AsyncHandler<ListOnPremisesInstancesRequest, ListOnPremisesInstancesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListOnPremisesInstancesResult>(){

            @Override
            public ListOnPremisesInstancesResult call() throws Exception {
                ListOnPremisesInstancesResult result;
                try {
                    result = AmazonCodeDeployAsyncClient.this.listOnPremisesInstances(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListOnPremisesInstancesResult> listOnPremisesInstancesAsync() {
        return this.listOnPremisesInstancesAsync(new ListOnPremisesInstancesRequest());
    }

    @Override
    public Future<ListOnPremisesInstancesResult> listOnPremisesInstancesAsync(AsyncHandler<ListOnPremisesInstancesRequest, ListOnPremisesInstancesResult> asyncHandler) {
        return this.listOnPremisesInstancesAsync(new ListOnPremisesInstancesRequest(), asyncHandler);
    }

    @Override
    public Future<Void> registerApplicationRevisionAsync(RegisterApplicationRevisionRequest request) {
        return this.registerApplicationRevisionAsync(request, null);
    }

    @Override
    public Future<Void> registerApplicationRevisionAsync(final RegisterApplicationRevisionRequest request, final AsyncHandler<RegisterApplicationRevisionRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonCodeDeployAsyncClient.this.registerApplicationRevision(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> registerOnPremisesInstanceAsync(RegisterOnPremisesInstanceRequest request) {
        return this.registerOnPremisesInstanceAsync(request, null);
    }

    @Override
    public Future<Void> registerOnPremisesInstanceAsync(final RegisterOnPremisesInstanceRequest request, final AsyncHandler<RegisterOnPremisesInstanceRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonCodeDeployAsyncClient.this.registerOnPremisesInstance(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> removeTagsFromOnPremisesInstancesAsync(RemoveTagsFromOnPremisesInstancesRequest request) {
        return this.removeTagsFromOnPremisesInstancesAsync(request, null);
    }

    @Override
    public Future<Void> removeTagsFromOnPremisesInstancesAsync(final RemoveTagsFromOnPremisesInstancesRequest request, final AsyncHandler<RemoveTagsFromOnPremisesInstancesRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonCodeDeployAsyncClient.this.removeTagsFromOnPremisesInstances(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopDeploymentResult> stopDeploymentAsync(StopDeploymentRequest request) {
        return this.stopDeploymentAsync(request, null);
    }

    @Override
    public Future<StopDeploymentResult> stopDeploymentAsync(final StopDeploymentRequest request, final AsyncHandler<StopDeploymentRequest, StopDeploymentResult> asyncHandler) {
        return this.executorService.submit(new Callable<StopDeploymentResult>(){

            @Override
            public StopDeploymentResult call() throws Exception {
                StopDeploymentResult result;
                try {
                    result = AmazonCodeDeployAsyncClient.this.stopDeployment(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> updateApplicationAsync(UpdateApplicationRequest request) {
        return this.updateApplicationAsync(request, null);
    }

    @Override
    public Future<Void> updateApplicationAsync(final UpdateApplicationRequest request, final AsyncHandler<UpdateApplicationRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonCodeDeployAsyncClient.this.updateApplication(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> updateApplicationAsync() {
        return this.updateApplicationAsync(new UpdateApplicationRequest());
    }

    @Override
    public Future<Void> updateApplicationAsync(AsyncHandler<UpdateApplicationRequest, Void> asyncHandler) {
        return this.updateApplicationAsync(new UpdateApplicationRequest(), asyncHandler);
    }

    @Override
    public Future<UpdateDeploymentGroupResult> updateDeploymentGroupAsync(UpdateDeploymentGroupRequest request) {
        return this.updateDeploymentGroupAsync(request, null);
    }

    @Override
    public Future<UpdateDeploymentGroupResult> updateDeploymentGroupAsync(final UpdateDeploymentGroupRequest request, final AsyncHandler<UpdateDeploymentGroupRequest, UpdateDeploymentGroupResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateDeploymentGroupResult>(){

            @Override
            public UpdateDeploymentGroupResult call() throws Exception {
                UpdateDeploymentGroupResult result;
                try {
                    result = AmazonCodeDeployAsyncClient.this.updateDeploymentGroup(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

