/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simplesystemsmanagement.model.SendCommandRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;

public class SendCommandRequestMarshaller
implements Marshaller<Request<SendCommandRequest>, SendCommandRequest> {
    @Override
    public Request<SendCommandRequest> marshall(SendCommandRequest sendCommandRequest) {
        if (sendCommandRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<SendCommandRequest> request = new DefaultRequest<SendCommandRequest>(sendCommandRequest, "AWSSimpleSystemsManagement");
        request.addHeader("X-Amz-Target", "AmazonSSM.SendCommand");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            Map<String, List<String>> parametersMap;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            SdkInternalList instanceIdsList = (SdkInternalList)sendCommandRequest.getInstanceIds();
            if (!instanceIdsList.isEmpty() || !instanceIdsList.isAutoConstruct()) {
                jsonWriter.key("InstanceIds");
                jsonWriter.array();
                for (String instanceIdsListValue : instanceIdsList) {
                    if (instanceIdsListValue == null) continue;
                    jsonWriter.value(instanceIdsListValue);
                }
                jsonWriter.endArray();
            }
            if (sendCommandRequest.getDocumentName() != null) {
                jsonWriter.key("DocumentName").value(sendCommandRequest.getDocumentName());
            }
            if (sendCommandRequest.getTimeoutSeconds() != null) {
                jsonWriter.key("TimeoutSeconds").value(sendCommandRequest.getTimeoutSeconds());
            }
            if (sendCommandRequest.getComment() != null) {
                jsonWriter.key("Comment").value(sendCommandRequest.getComment());
            }
            if ((parametersMap = sendCommandRequest.getParameters()) != null) {
                jsonWriter.key("Parameters");
                jsonWriter.object();
                for (Map.Entry<String, List<String>> parametersMapValue : parametersMap.entrySet()) {
                    if (parametersMapValue.getValue() == null) continue;
                    jsonWriter.key(parametersMapValue.getKey());
                    jsonWriter.array();
                    for (String parametersMapValueList : parametersMapValue.getValue()) {
                        if (parametersMapValueList == null) continue;
                        jsonWriter.value(parametersMapValueList);
                    }
                    jsonWriter.endArray();
                }
                jsonWriter.endObject();
            }
            if (sendCommandRequest.getOutputS3BucketName() != null) {
                jsonWriter.key("OutputS3BucketName").value(sendCommandRequest.getOutputS3BucketName());
            }
            if (sendCommandRequest.getOutputS3KeyPrefix() != null) {
                jsonWriter.key("OutputS3KeyPrefix").value(sendCommandRequest.getOutputS3KeyPrefix());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

