/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.redshift.model.DescribeSnapshotCopyGrantsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribeSnapshotCopyGrantsRequestMarshaller
implements Marshaller<Request<DescribeSnapshotCopyGrantsRequest>, DescribeSnapshotCopyGrantsRequest> {
    @Override
    public Request<DescribeSnapshotCopyGrantsRequest> marshall(DescribeSnapshotCopyGrantsRequest describeSnapshotCopyGrantsRequest) {
        if (describeSnapshotCopyGrantsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeSnapshotCopyGrantsRequest> request = new DefaultRequest<DescribeSnapshotCopyGrantsRequest>(describeSnapshotCopyGrantsRequest, "AmazonRedshift");
        request.addParameter("Action", "DescribeSnapshotCopyGrants");
        request.addParameter("Version", "2012-12-01");
        if (describeSnapshotCopyGrantsRequest.getSnapshotCopyGrantName() != null) {
            request.addParameter("SnapshotCopyGrantName", StringUtils.fromString(describeSnapshotCopyGrantsRequest.getSnapshotCopyGrantName()));
        }
        if (describeSnapshotCopyGrantsRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger(describeSnapshotCopyGrantsRequest.getMaxRecords()));
        }
        if (describeSnapshotCopyGrantsRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString(describeSnapshotCopyGrantsRequest.getMarker()));
        }
        List<String> tagKeysList = describeSnapshotCopyGrantsRequest.getTagKeys();
        int tagKeysListIndex = 1;
        for (String tagKeysListValue : tagKeysList) {
            if (tagKeysListValue != null) {
                request.addParameter("TagKeys.TagKey." + tagKeysListIndex, StringUtils.fromString(tagKeysListValue));
            }
            ++tagKeysListIndex;
        }
        List<String> tagValuesList = describeSnapshotCopyGrantsRequest.getTagValues();
        int tagValuesListIndex = 1;
        for (String tagValuesListValue : tagValuesList) {
            if (tagValuesListValue != null) {
                request.addParameter("TagValues.TagValue." + tagValuesListIndex, StringUtils.fromString(tagValuesListValue));
            }
            ++tagValuesListIndex;
        }
        return request;
    }
}

