/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.kinesis.model.ListTagsForStreamRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class ListTagsForStreamRequestMarshaller
implements Marshaller<Request<ListTagsForStreamRequest>, ListTagsForStreamRequest> {
    @Override
    public Request<ListTagsForStreamRequest> marshall(ListTagsForStreamRequest listTagsForStreamRequest) {
        if (listTagsForStreamRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListTagsForStreamRequest> request = new DefaultRequest<ListTagsForStreamRequest>(listTagsForStreamRequest, "AmazonKinesis");
        request.addHeader("X-Amz-Target", "Kinesis_20131202.ListTagsForStream");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (listTagsForStreamRequest.getStreamName() != null) {
                jsonWriter.key("StreamName").value(listTagsForStreamRequest.getStreamName());
            }
            if (listTagsForStreamRequest.getExclusiveStartTagKey() != null) {
                jsonWriter.key("ExclusiveStartTagKey").value(listTagsForStreamRequest.getExclusiveStartTagKey());
            }
            if (listTagsForStreamRequest.getLimit() != null) {
                jsonWriter.key("Limit").value(listTagsForStreamRequest.getLimit());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

