/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.iot.model.ThingAttribute;
import com.amazonaws.util.json.JSONWriter;
import java.util.Map;

public class ThingAttributeJsonMarshaller {
    private static ThingAttributeJsonMarshaller instance;

    public void marshall(ThingAttribute thingAttribute, JSONWriter jsonWriter) {
        if (thingAttribute == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            Map<String, String> attributesMap;
            jsonWriter.object();
            if (thingAttribute.getThingName() != null) {
                jsonWriter.key("thingName").value(thingAttribute.getThingName());
            }
            if ((attributesMap = thingAttribute.getAttributes()) != null) {
                jsonWriter.key("attributes");
                jsonWriter.object();
                for (Map.Entry<String, String> attributesMapValue : attributesMap.entrySet()) {
                    if (attributesMapValue.getValue() == null) continue;
                    jsonWriter.key(attributesMapValue.getKey());
                    jsonWriter.value(attributesMapValue.getValue());
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ThingAttributeJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ThingAttributeJsonMarshaller();
        }
        return instance;
    }
}

