/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.inspector.model.Attribute;
import com.amazonaws.services.inspector.model.FindingsFilter;
import com.amazonaws.services.inspector.model.transform.AttributeJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;
import java.util.List;

public class FindingsFilterJsonMarshaller {
    private static FindingsFilterJsonMarshaller instance;

    public void marshall(FindingsFilter findingsFilter, JSONWriter jsonWriter) {
        if (findingsFilter == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<Attribute> userAttributesList;
            List<Attribute> attributesList;
            List<String> severitiesList;
            List<String> ruleNamesList;
            jsonWriter.object();
            List<String> rulesPackageArnsList = findingsFilter.getRulesPackageArns();
            if (rulesPackageArnsList != null) {
                jsonWriter.key("rulesPackageArns");
                jsonWriter.array();
                for (String rulesPackageArnsListValue : rulesPackageArnsList) {
                    if (rulesPackageArnsListValue == null) continue;
                    jsonWriter.value(rulesPackageArnsListValue);
                }
                jsonWriter.endArray();
            }
            if ((ruleNamesList = findingsFilter.getRuleNames()) != null) {
                jsonWriter.key("ruleNames");
                jsonWriter.array();
                for (String ruleNamesListValue : ruleNamesList) {
                    if (ruleNamesListValue == null) continue;
                    jsonWriter.value(ruleNamesListValue);
                }
                jsonWriter.endArray();
            }
            if ((severitiesList = findingsFilter.getSeverities()) != null) {
                jsonWriter.key("severities");
                jsonWriter.array();
                for (String severitiesListValue : severitiesList) {
                    if (severitiesListValue == null) continue;
                    jsonWriter.value(severitiesListValue);
                }
                jsonWriter.endArray();
            }
            if ((attributesList = findingsFilter.getAttributes()) != null) {
                jsonWriter.key("attributes");
                jsonWriter.array();
                for (Attribute attributesListValue : attributesList) {
                    if (attributesListValue == null) continue;
                    AttributeJsonMarshaller.getInstance().marshall(attributesListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if ((userAttributesList = findingsFilter.getUserAttributes()) != null) {
                jsonWriter.key("userAttributes");
                jsonWriter.array();
                for (Attribute userAttributesListValue : userAttributesList) {
                    if (userAttributesListValue == null) continue;
                    AttributeJsonMarshaller.getInstance().marshall(userAttributesListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static FindingsFilterJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new FindingsFilterJsonMarshaller();
        }
        return instance;
    }
}

