/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.services.elastictranscoder.model.Job;
import com.amazonaws.services.elastictranscoder.model.JobOutput;
import com.amazonaws.services.elastictranscoder.model.Playlist;
import com.amazonaws.services.elastictranscoder.model.transform.JobInputJsonMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.JobOutputJsonMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.PlaylistJsonMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.TimingJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;
import java.util.Map;

public class JobJsonMarshaller {
    private static JobJsonMarshaller instance;

    public void marshall(Job job, JSONWriter jsonWriter) {
        if (job == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalMap userMetadataMap;
            SdkInternalList playlistsList;
            SdkInternalList outputsList;
            jsonWriter.object();
            if (job.getId() != null) {
                jsonWriter.key("Id").value(job.getId());
            }
            if (job.getArn() != null) {
                jsonWriter.key("Arn").value(job.getArn());
            }
            if (job.getPipelineId() != null) {
                jsonWriter.key("PipelineId").value(job.getPipelineId());
            }
            if (job.getInput() != null) {
                jsonWriter.key("Input");
                JobInputJsonMarshaller.getInstance().marshall(job.getInput(), jsonWriter);
            }
            if (job.getOutput() != null) {
                jsonWriter.key("Output");
                JobOutputJsonMarshaller.getInstance().marshall(job.getOutput(), jsonWriter);
            }
            if (!(outputsList = (SdkInternalList)job.getOutputs()).isEmpty() || !outputsList.isAutoConstruct()) {
                jsonWriter.key("Outputs");
                jsonWriter.array();
                for (JobOutput outputsListValue : outputsList) {
                    if (outputsListValue == null) continue;
                    JobOutputJsonMarshaller.getInstance().marshall(outputsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (job.getOutputKeyPrefix() != null) {
                jsonWriter.key("OutputKeyPrefix").value(job.getOutputKeyPrefix());
            }
            if (!(playlistsList = (SdkInternalList)job.getPlaylists()).isEmpty() || !playlistsList.isAutoConstruct()) {
                jsonWriter.key("Playlists");
                jsonWriter.array();
                for (Playlist playlistsListValue : playlistsList) {
                    if (playlistsListValue == null) continue;
                    PlaylistJsonMarshaller.getInstance().marshall(playlistsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (job.getStatus() != null) {
                jsonWriter.key("Status").value(job.getStatus());
            }
            if (!(userMetadataMap = (SdkInternalMap)job.getUserMetadata()).isEmpty() || !userMetadataMap.isAutoConstruct()) {
                jsonWriter.key("UserMetadata");
                jsonWriter.object();
                for (Map.Entry userMetadataMapValue : userMetadataMap.entrySet()) {
                    if (userMetadataMapValue.getValue() == null) continue;
                    jsonWriter.key((String)userMetadataMapValue.getKey());
                    jsonWriter.value(userMetadataMapValue.getValue());
                }
                jsonWriter.endObject();
            }
            if (job.getTiming() != null) {
                jsonWriter.key("Timing");
                TimingJsonMarshaller.getInstance().marshall(job.getTiming(), jsonWriter);
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static JobJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new JobJsonMarshaller();
        }
        return instance;
    }
}

