/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticfilesystem.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticfilesystem.model.CreateMountTargetRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class CreateMountTargetRequestMarshaller
implements Marshaller<Request<CreateMountTargetRequest>, CreateMountTargetRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<CreateMountTargetRequest> marshall(CreateMountTargetRequest createMountTargetRequest) {
        if (createMountTargetRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateMountTargetRequest> request = new DefaultRequest<CreateMountTargetRequest>(createMountTargetRequest, "AmazonElasticFileSystem");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2015-02-01/mount-targets";
        request.setResourcePath(uriResourcePath);
        try {
            SdkInternalList securityGroupsList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (createMountTargetRequest.getFileSystemId() != null) {
                jsonWriter.key("FileSystemId").value(createMountTargetRequest.getFileSystemId());
            }
            if (createMountTargetRequest.getSubnetId() != null) {
                jsonWriter.key("SubnetId").value(createMountTargetRequest.getSubnetId());
            }
            if (createMountTargetRequest.getIpAddress() != null) {
                jsonWriter.key("IpAddress").value(createMountTargetRequest.getIpAddress());
            }
            if (!(securityGroupsList = (SdkInternalList)createMountTargetRequest.getSecurityGroups()).isEmpty() || !securityGroupsList.isAutoConstruct()) {
                jsonWriter.key("SecurityGroups");
                jsonWriter.array();
                for (String securityGroupsListValue : securityGroupsList) {
                    if (securityGroupsListValue == null) continue;
                    jsonWriter.value(securityGroupsListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

