/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model.transform;

import com.amazonaws.services.cloudformation.model.Stack;
import com.amazonaws.services.cloudformation.model.transform.OutputStaxUnmarshaller;
import com.amazonaws.services.cloudformation.model.transform.ParameterStaxUnmarshaller;
import com.amazonaws.services.cloudformation.model.transform.TagStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class StackStaxUnmarshaller
implements Unmarshaller<Stack, StaxUnmarshallerContext> {
    private static StackStaxUnmarshaller instance;

    @Override
    public Stack unmarshall(StaxUnmarshallerContext context) throws Exception {
        Stack stack = new Stack();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return stack;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("StackId", targetDepth)) {
                    stack.setStackId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("StackName", targetDepth)) {
                    stack.setStackName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Description", targetDepth)) {
                    stack.setDescription(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Parameters/member", targetDepth)) {
                    stack.getParameters().add(ParameterStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CreationTime", targetDepth)) {
                    stack.setCreationTime(SimpleTypeStaxUnmarshallers.DateStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("LastUpdatedTime", targetDepth)) {
                    stack.setLastUpdatedTime(SimpleTypeStaxUnmarshallers.DateStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("StackStatus", targetDepth)) {
                    stack.setStackStatus(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("StackStatusReason", targetDepth)) {
                    stack.setStackStatusReason(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DisableRollback", targetDepth)) {
                    stack.setDisableRollback(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("NotificationARNs/member", targetDepth)) {
                    stack.getNotificationARNs().add(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("TimeoutInMinutes", targetDepth)) {
                    stack.setTimeoutInMinutes(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Capabilities/member", targetDepth)) {
                    stack.getCapabilities().add(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Outputs/member", targetDepth)) {
                    stack.getOutputs().add(OutputStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Tags/member", targetDepth)) continue;
                stack.getTags().add(TagStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return stack;
    }

    public static StackStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new StackStaxUnmarshaller();
        }
        return instance;
    }
}

