/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.ecs.model.HostEntry;
import com.amazonaws.util.json.JSONWriter;

public class HostEntryJsonMarshaller {
    private static HostEntryJsonMarshaller instance;

    public void marshall(HostEntry hostEntry, JSONWriter jsonWriter) {
        if (hostEntry == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (hostEntry.getHostname() != null) {
                jsonWriter.key("hostname").value(hostEntry.getHostname());
            }
            if (hostEntry.getIpAddress() != null) {
                jsonWriter.key("ipAddress").value(hostEntry.getIpAddress());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static HostEntryJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new HostEntryJsonMarshaller();
        }
        return instance;
    }
}

