/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.ModifyHostsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class ModifyHostsRequestMarshaller
implements Marshaller<Request<ModifyHostsRequest>, ModifyHostsRequest> {
    @Override
    public Request<ModifyHostsRequest> marshall(ModifyHostsRequest modifyHostsRequest) {
        if (modifyHostsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ModifyHostsRequest> request = new DefaultRequest<ModifyHostsRequest>(modifyHostsRequest, "AmazonEC2");
        request.addParameter("Action", "ModifyHosts");
        request.addParameter("Version", "2015-10-01");
        List<String> hostIdsList = modifyHostsRequest.getHostIds();
        int hostIdsListIndex = 1;
        for (String hostIdsListValue : hostIdsList) {
            if (hostIdsListValue != null) {
                request.addParameter("HostId." + hostIdsListIndex, StringUtils.fromString(hostIdsListValue));
            }
            ++hostIdsListIndex;
        }
        if (modifyHostsRequest.getAutoPlacement() != null) {
            request.addParameter("AutoPlacement", StringUtils.fromString(modifyHostsRequest.getAutoPlacement()));
        }
        return request;
    }
}

