/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.DeleteFlowLogsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DeleteFlowLogsRequestMarshaller
implements Marshaller<Request<DeleteFlowLogsRequest>, DeleteFlowLogsRequest> {
    @Override
    public Request<DeleteFlowLogsRequest> marshall(DeleteFlowLogsRequest deleteFlowLogsRequest) {
        if (deleteFlowLogsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteFlowLogsRequest> request = new DefaultRequest<DeleteFlowLogsRequest>(deleteFlowLogsRequest, "AmazonEC2");
        request.addParameter("Action", "DeleteFlowLogs");
        request.addParameter("Version", "2015-10-01");
        List<String> flowLogIdsList = deleteFlowLogsRequest.getFlowLogIds();
        int flowLogIdsListIndex = 1;
        for (String flowLogIdsListValue : flowLogIdsList) {
            if (flowLogIdsListValue != null) {
                request.addParameter("FlowLogId." + flowLogIdsListIndex, StringUtils.fromString(flowLogIdsListValue));
            }
            ++flowLogIdsListIndex;
        }
        return request;
    }
}

