/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ScheduledInstanceRecurrence
implements Serializable,
Cloneable {
    private String frequency;
    private Integer interval;
    private ListWithAutoConstructFlag<Integer> occurrenceDaySet;
    private Boolean occurrenceRelativeToEnd;
    private String occurrenceUnit;

    public String getFrequency() {
        return this.frequency;
    }

    public void setFrequency(String frequency) {
        this.frequency = frequency;
    }

    public ScheduledInstanceRecurrence withFrequency(String frequency) {
        this.frequency = frequency;
        return this;
    }

    public Integer getInterval() {
        return this.interval;
    }

    public void setInterval(Integer interval) {
        this.interval = interval;
    }

    public ScheduledInstanceRecurrence withInterval(Integer interval) {
        this.interval = interval;
        return this;
    }

    public List<Integer> getOccurrenceDaySet() {
        if (this.occurrenceDaySet == null) {
            this.occurrenceDaySet = new ListWithAutoConstructFlag();
            this.occurrenceDaySet.setAutoConstruct(true);
        }
        return this.occurrenceDaySet;
    }

    public void setOccurrenceDaySet(Collection<Integer> occurrenceDaySet) {
        if (occurrenceDaySet == null) {
            this.occurrenceDaySet = null;
            return;
        }
        ListWithAutoConstructFlag occurrenceDaySetCopy = new ListWithAutoConstructFlag(occurrenceDaySet.size());
        occurrenceDaySetCopy.addAll(occurrenceDaySet);
        this.occurrenceDaySet = occurrenceDaySetCopy;
    }

    public ScheduledInstanceRecurrence withOccurrenceDaySet(Integer ... occurrenceDaySet) {
        if (this.getOccurrenceDaySet() == null) {
            this.setOccurrenceDaySet(new ArrayList<Integer>(occurrenceDaySet.length));
        }
        for (Integer value : occurrenceDaySet) {
            this.getOccurrenceDaySet().add(value);
        }
        return this;
    }

    public ScheduledInstanceRecurrence withOccurrenceDaySet(Collection<Integer> occurrenceDaySet) {
        if (occurrenceDaySet == null) {
            this.occurrenceDaySet = null;
        } else {
            ListWithAutoConstructFlag occurrenceDaySetCopy = new ListWithAutoConstructFlag(occurrenceDaySet.size());
            occurrenceDaySetCopy.addAll(occurrenceDaySet);
            this.occurrenceDaySet = occurrenceDaySetCopy;
        }
        return this;
    }

    public Boolean isOccurrenceRelativeToEnd() {
        return this.occurrenceRelativeToEnd;
    }

    public void setOccurrenceRelativeToEnd(Boolean occurrenceRelativeToEnd) {
        this.occurrenceRelativeToEnd = occurrenceRelativeToEnd;
    }

    public ScheduledInstanceRecurrence withOccurrenceRelativeToEnd(Boolean occurrenceRelativeToEnd) {
        this.occurrenceRelativeToEnd = occurrenceRelativeToEnd;
        return this;
    }

    public Boolean getOccurrenceRelativeToEnd() {
        return this.occurrenceRelativeToEnd;
    }

    public String getOccurrenceUnit() {
        return this.occurrenceUnit;
    }

    public void setOccurrenceUnit(String occurrenceUnit) {
        this.occurrenceUnit = occurrenceUnit;
    }

    public ScheduledInstanceRecurrence withOccurrenceUnit(String occurrenceUnit) {
        this.occurrenceUnit = occurrenceUnit;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFrequency() != null) {
            sb.append("Frequency: " + this.getFrequency() + ",");
        }
        if (this.getInterval() != null) {
            sb.append("Interval: " + this.getInterval() + ",");
        }
        if (this.getOccurrenceDaySet() != null) {
            sb.append("OccurrenceDaySet: " + this.getOccurrenceDaySet() + ",");
        }
        if (this.isOccurrenceRelativeToEnd() != null) {
            sb.append("OccurrenceRelativeToEnd: " + this.isOccurrenceRelativeToEnd() + ",");
        }
        if (this.getOccurrenceUnit() != null) {
            sb.append("OccurrenceUnit: " + this.getOccurrenceUnit());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFrequency() == null ? 0 : this.getFrequency().hashCode());
        hashCode = 31 * hashCode + (this.getInterval() == null ? 0 : this.getInterval().hashCode());
        hashCode = 31 * hashCode + (this.getOccurrenceDaySet() == null ? 0 : this.getOccurrenceDaySet().hashCode());
        hashCode = 31 * hashCode + (this.isOccurrenceRelativeToEnd() == null ? 0 : this.isOccurrenceRelativeToEnd().hashCode());
        hashCode = 31 * hashCode + (this.getOccurrenceUnit() == null ? 0 : this.getOccurrenceUnit().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledInstanceRecurrence)) {
            return false;
        }
        ScheduledInstanceRecurrence other = (ScheduledInstanceRecurrence)obj;
        if (other.getFrequency() == null ^ this.getFrequency() == null) {
            return false;
        }
        if (other.getFrequency() != null && !other.getFrequency().equals(this.getFrequency())) {
            return false;
        }
        if (other.getInterval() == null ^ this.getInterval() == null) {
            return false;
        }
        if (other.getInterval() != null && !other.getInterval().equals(this.getInterval())) {
            return false;
        }
        if (other.getOccurrenceDaySet() == null ^ this.getOccurrenceDaySet() == null) {
            return false;
        }
        if (other.getOccurrenceDaySet() != null && !other.getOccurrenceDaySet().equals(this.getOccurrenceDaySet())) {
            return false;
        }
        if (other.isOccurrenceRelativeToEnd() == null ^ this.isOccurrenceRelativeToEnd() == null) {
            return false;
        }
        if (other.isOccurrenceRelativeToEnd() != null && !other.isOccurrenceRelativeToEnd().equals(this.isOccurrenceRelativeToEnd())) {
            return false;
        }
        if (other.getOccurrenceUnit() == null ^ this.getOccurrenceUnit() == null) {
            return false;
        }
        return other.getOccurrenceUnit() == null || other.getOccurrenceUnit().equals(this.getOccurrenceUnit());
    }

    public ScheduledInstanceRecurrence clone() {
        try {
            return (ScheduledInstanceRecurrence)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

